% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation-tern.R
\name{annotate}
\alias{annotate}
\title{Create an annotation layer (ggtern version).}
\usage{
annotate(
  geom,
  x = NULL,
  y = NULL,
  z = NULL,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  zmin = NULL,
  zmax = NULL,
  xend = NULL,
  yend = NULL,
  zend = NULL,
  ...,
  na.rm = FALSE
)
}
\arguments{
\item{geom}{name of geom to use for annotation}

\item{x, y, z, xmin, ymin, zmin, xmax, ymax, zmax, xend, yend, zend}{positioning aesthetics -
you must specify at least one of these.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}
}
\description{
This function adds geoms to a plot. Unlike typical a geom function,
the properties of the geoms are not mapped from variables of a data frame,
but are instead passed in as vectors. This is useful for adding small annotations
(such as text labels) or if you have your data in vectors, and for some
reason don't want to put them in a data frame.
}
\details{
Note that all position aesthetics are scaled (i.e. they will expand the
limits of the plot so they are visible), but all other aesthetics are
set. This means that layers created with this function will never
affect the legend.
}
\examples{
ggtern() + 
annotate(geom  = 'text',
              x     = c(0.5,1/3,0.0),
              y     = c(0.5,1/3,0.0),
              z     = c(0.0,1/3,1.0),
              angle = c(0,30,60),
              vjust = c(1.5,0.5,-0.5),
              label = paste("Point",c("A","B","C")),
              color = c("green","red",'blue')) +
  theme_dark() + 
  theme_nomask()
}
\seealso{
\code{\link[ggplot2]{annotate}}
}
\author{
Nicholas Hamilton
}
