% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/savePlot.R
\name{savePlot}
\alias{savePlot}
\title{Save a plot}
\usage{
savePlot(plot, names, savePath = "")
}
\arguments{
\item{plot}{'ggplot2' object. The plot to be saved.}

\item{names}{List. List of at least 2 items, first the dataset name,
second the x variable of the plot, and third the y variable of the plot (only in bivariate plots).}

\item{savePath}{Character (optional). String specifying the path and filename for the exported plot.\cr
The format must be: 'filepath/filename.extension' where:
\itemize{
\item filepath is the directory (must already exist), default to the working directory;
\item filename is the name of the file, default to default_filename;
\item extension must be one of the supported 'ggsave' extensions, must exists unless using the default file name.
}}
}
\value{
A status number, 0 if the save was successfull, -1 if there were errors.
}
\description{
Internal function to save a 1D or 2D ggplot2 plot specifying the filepath, filename and extension.
Supported extensions are the ones supported by 'ggsave', default extension is .png.
Default_filename is in this format: 'plot_Dataset_var1_var2_timestamp.png'
}
\details{
The functions takes a table1 object, a character vector containing the dataset name and the save path to export the table.
It first checks whether the dataset name is present, the it creates the default file name.
If the save path doesn't exist or in an empty string it saves the plot in the working directory using the default file name.
If the save path exists but doesn't contain the file name, it saves the plot in the path directory using the default file name.
If the save path exists and has a file name, it saves the plot in the path directory with the user chosen file name.
}
\seealso{
This internal functions is used by: \code{\link[=plotMunich2019dataset]{plotMunich2019dataset()}}, \code{\link[=plotTainan2020dataset]{plotTainan2020dataset()}} and \code{\link[=plotUtrecht2019dataset]{plotUtrecht2019dataset()}}
}
\keyword{internal}
