% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emyxmiss.R
\name{emyxmiss}
\alias{emyxmiss}
\title{Fitting generalized linear models with Incomplete data}
\usage{
emyxmiss(
  formula,
  data,
  adtnlCovforR = NULL,
  eps0 = 0.001,
  maxit = 75,
  family = "binomial",
  method = "glm.fit"
)
}
\arguments{
\item{formula}{a formula expression as for regression models, of the form \code{response ~ predictors}. The response should be a numeric binary variable with missing values, and predictors can be any variables. A predictor with categorical values with missing can be used in the model. See the documentation of formula for other details.}

\item{data}{an optional data frame in which to interpret the variables occurring in formula.}

\item{adtnlCovforR}{an optional list of covariates to be used to fit the logistic regression \code{logit(R) ~ response+predictors+adtnlCovforR}. \code{adtnlCovforR} has to be supplied as a vector. Default is \code{NULL}.}

\item{eps0}{arguments to be used to for the convergence criteria of the maximum likelihood computation of the joint likelihood function. The default is 1e-3.}

\item{maxit}{arguments to be used to for the maximization of the joint likelihood function. The default is 50.}

\item{family}{A character string specifying the type of model family.}

\item{method}{a method="brglmFit" or method="glm.fit" will be used for fitting model. The method="brglmFit" fits generalized linear models using bias reduction methods (Kosmidis, 2014), and other penalized maximum likelihood methods.}
}
\value{
return the generalized linear model estimates
}
\description{
This function enables users to fit generalized linear models when handling incomplete data in both the response variable and categorical covariates. The missing responses are assumed to be nonignorable, while missing categorical covariates are assumed to be missing at random. The model is fitted using a novel likelihood-based method proposed by Pradhan, Nychka, and Bandyopadhyay (2025).
}
\details{
The \code{family} parameter in the \code{emyxmmiss} function allows you to specify the probability distribution and link function for the response variable in the linear model. It determines the nature of the relationship between the predictors and the response variable.
The \code{family} argument is particularly important when working with binary data, where the response variable has only two possible outcomes. In such cases, you typically want to fit a logistic regression model.

The following commonly used families are supported for binary data:
\itemize{
\item "binomial" for a binomial distribution, suitable for binary or dichotomous response variables.
}

You can also specify different link functions within each family. For the "binomial" family, the default link function is the logit function, which models the log-odds of success. Other available link functions include:
\itemize{
\item "probit" for the probit link function, which models the cumulative standard normal distribution.
\item "cloglog" for the complementary log-log link function, which models the complementary log-log of the survival function.
}

It is important to choose the appropriate \code{family} and \code{link} function based on the specific characteristics and assumptions of your binary data. The default "binomial" family with the logit link function is often a good starting point, but alternative link functions might be more appropriate depending on the research question and the nature of the data.
}
\examples{
\donttest{
data(testyxm) # testyxm is a list called dt
dataWithMiss <- testyxm$dataMissing
# Binary regression with link=logit
fit_yx <- emyxmiss(Wheeze ~ city + soc + cond,
                   data = dataWithMiss,
                   adtnlCovforR = c("age"),
                   family = binomial(link = "logit"),
                   method = "brglmFit")
fit_yx

# Binary regression with link=probit
fit_yx <- emyxmiss(Wheeze ~ city + soc + cond,
                   data = dataWithMiss,
                   adtnlCovforR = c("age"),
                   family = binomial(link = "probit"))
fit_yx


# Firth correction and link=probit
fit_yx <- emyxmiss(Wheeze ~ city + soc + cond,
                   data = dataWithMiss,
                   adtnlCovforR = c("age"),
                   family = binomial(link = "probit"),
                   method = "brglmFit")
fit_yx

# on simulated data
demo_df <- simulateCovariateData(50, nCov=6)
simulated_df <- simulateData(demo_df)
testMissData <- simulated_df$dataMissing
fit_yx <- emyxmiss(y~x2+x3+x4,
                   data=testMissData,
                   adtnlCovforR=c("x1"),
                   family=binomial,
                   method="glm.fit")
fit_yx
summary(fit_yx$fit_y)
}
}
\references{
Firth, D. (1993). Bias reduction of maximum likelihood estimates, Biometrika, 80, 27-38. doi:10.2307/2336755.

Ibrahim, J. G. (1990). Incomplete data in generalized linear models. Journal of the American Statistical Association 85, 765–769.

Ibrahim, J. G., and Lipsitz, S. R. (1996). Parameter Estimation from Incom- plete Data in Binomial Regression when the Missing Data Mechanism is Nonignorable, Biometrics, 52, 1071–1078.

Kosmidis, I., Firth, D. (2021). Jeffreys-prior penalty, finiteness and shrinkage in binomial-response generalized linear models. Biometrika, 108, 71-82. doi:10.1093/biomet/asaa052.

Louis, T. A. (1982). Finding the observed information when using the EM algorithm. Proceedings of the Royal Statistical Society, Ser B, 44, 226-233.

Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.

Pradhan V, Nychka DW, Bandyopadhyay S (2025).  Addressing Missing Responses and Categorical Covariates in Binary Regression Modeling: An Integrated Framework  (to be submitted).
}
