% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateData.R
\name{simulateData}
\alias{simulateData}
\title{Simulate data based on an input covariate data}
\usage{
simulateData(
  dataCov,
  truebeta = c(1, -1, 1, 5),
  truealpha = c(-1, 5, -1, -1, -1, 0.01),
  nsim = 2
)
}
\arguments{
\item{dataCov}{input data, the default number of covariates is 7 (5+2)}

\item{truebeta}{the beta parameter to be used to generate binary response values 1/0 s \code{logit(y=1)=x1+x2+x3}}

\item{truealpha}{to be used to generate nonignorable missing values based on the model \code{logit(R=1)=y+x1+x2+x3+x4+..}}

\item{nsim}{number of simulated dataset, default is 2}
}
\value{
returns a list with original data called originalData and a data with imputed missing values dataMissing
}
\description{
This function generates missing data both in the response variables as well as in the predictors. The missing data generation in the last two supplied covariates will be generated based on a predefined mechanisms. Missing data generation in the response variable will be based on the suppilied true alpha.
}
\examples{
demo_df <- simulateCovariateData(100, nCov=6)
simulated_df <- simulateData(demo_df, nsim=2)
testMissData <- simulated_df$dataMissing
head(testMissData)

}
