# tests/testthat/test-emBinRegMixedMAR.R

library(testthat)
library(glmfitmiss)  # Load your package

# Ensure the data is loaded correctly
data("testyxm", package = "glmfitmiss")
dataWithMiss <- testyxm$dataMissing  # Assuming 'testyxm' is the correct dataset

test_that("emBinRegMixedMAR works correctly", {
  # Fit the model
  f_fit <- emBinRegMixedMAR(Wheeze ~ city + soc + cond,
                            data = dataWithMiss,
                            adtnlCovforR = c("age"),
                            biascorrectn=TRUE)

  # Using expect_snapshot to check the content of beta and alpha
  expect_snapshot({
    print(f_fit$beta)
    print(f_fit$alpha)
  })

  # Check the type of f_fit$beta and f_fit$alpha if they are data frames or specific S3 objects
  expect_true(is.data.frame(f_fit$beta) || is.list(f_fit$beta))  # Adjust based on actual expected type
  expect_true(is.data.frame(f_fit$alpha) || is.list(f_fit$alpha))  # Adjust based on actual expected type
})

data("meningitis60ymis", package = "glmfitmiss")

test_that("emBinRegMixedMAR with Firth works correctly", {
  # Fit the model
  fit2 <- emBinRegMixedMAR(resp~Numnill+Numsleep+Smoke+Set+Reftime,
                           data=meningitis60ymis, biascorrectn=TRUE)

  # Using expect_snapshot to check the content of beta and alpha
  expect_snapshot({
    print(fit2$beta)
    print(fit2$alpha)
  })

  # Check the type of f_fit$beta and f_fit$alpha if they are data frames or specific S3 objects
  expect_true(is.data.frame(fit2$beta) || is.list(fit2$beta))  # Adjust based on actual expected type
  expect_true(is.data.frame(fit2$alpha) || is.list(fit2$alpha))  # Adjust based on actual expected type
})
