# goeveg R-package
Functions for Community Data and Ordinations

A collection of functions useful in vegetation community analyses and ordinations.\
The ordination functions work as an addition to the functions from the `vegan`-package. 

## Features

* Automatic species selection for ordination diagrams based on cover abundances and species fit (`ordiselect` - function)
* Generation of species response curves (`specresponse` - function)
* Scree/stress plots for NMDS (`screeplot_NMDS` - function)
* Rank-abundance curve plotting for single or multiple samples (`racurve` and `racurves`-functions)
* Calculation and sorting of synoptic tables with group-wise frequencies, fidelity and differential species assessment (`syntable` and `synsort` functions)
* Heterogeneity-constrained random (HCR) resampling (Lengyel, Chytrý & Tichý, 2011) of community data (`hcr_resampling` function)
* Taxa merging for taxa with identical names (`merge_taxa` - function)
* One-step cleaning and transposing of vegetation matrices: (`clean_matrix` and `trans_matrix` - functions)
* Conversion between cover-abundance codes and percentage cover (`cov2per` and `per2cov` - functions)

Furthermore some basic functions are included, such as standard error of the mean `sem`, coefficient of variance `cv` or conversion between degrees and radians `deg2rad`/`rad2deg`.


## Installation

Install the released version from CRAN:

``` r
install.packages("goeveg")
```

Install the latest version from Github using [`remotes`](https://github.com/r-lib/remotes)

``` r
remotes::install_github("fvlampe/goeveg")
```
