% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updatemat.R
\name{updatemat}
\alias{updatemat}
\title{Update Interaction Matrix with Group Assignments}
\usage{
updatemat(initialmat, group_assignments, students)
}
\arguments{
\item{initialmat}{A square matrix where rows and columns represent students, and cell values track
the number of times two students have been grouped together.}

\item{group_assignments}{A vector indicating the group assignments for each student.}

\item{students}{A vector containing student identifiers corresponding to the matrix row and column names.}
}
\value{
An updated matrix reflecting the new group assignments.
}
\description{
This function updates an existing interaction matrix based on new group assignments.
It increments the matrix values to track how often students have been grouped together.
}
\examples{
n_students <- 4
student_data <- GenerateData(n_students)
initial_matrix <- initmat(student_data$Student)
group_assignments <- c(1, 1, 2, 2)  # Example group assignments

updated_matrix <- updatemat(initial_matrix, group_assignments, student_data$Student)
updated_matrix
}
