% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcut.R
\name{shortcut_create}
\alias{shortcut_create}
\title{Create a shortcut to a Drive file}
\usage{
shortcut_create(file, path = NULL, name = NULL, overwrite = NA)
}
\arguments{
\item{file}{Something that identifies the file of interest on your Google
Drive. Can be a name or path, a file id or URL marked with \code{\link[=as_id]{as_id()}}, or a
\code{\link{dribble}}.}

\item{path}{Target destination for the new shortcut, i.e. a folder or a
shared drive. Can be given as an actual path (character), a file id or URL
marked with \code{\link[=as_id]{as_id()}}, or a \code{\link{dribble}}. Defaults to your "My Drive" root
folder. If \code{path} is a shortcut to a folder, it is automatically resolved
to its target folder.}

\item{name}{Character, new shortcut name if not specified as part of
\code{path}. This will force \code{path} to be interpreted as a folder, even if it
is character and lacks a trailing slash. By default, the shortcut starts out with the same name as
the target \code{file}. As a consequence, if you want to use
\code{overwrite = TRUE} or \code{overwrite = FALSE}, you \strong{must} explicitly
specify the shortcut's \code{name}.}

\item{overwrite}{Logical, indicating whether to check for a pre-existing file
at the targetted "filepath". The quotes around "filepath" refer to the fact
that Drive does not impose a 1-to-1 relationship between filepaths and files,
like a typical file system; read more about that in \code{\link[=drive_get]{drive_get()}}.
\itemize{
\item \code{NA} (default): Just do the operation, even if it results in multiple
files with the same filepath.
\item \code{TRUE}: Check for a pre-existing file at the filepath. If there is
zero or one, move a pre-existing file to the trash, then carry on. Note
that the new file does not inherit any properties from the old one, such
as sharing or publishing settings. It will have a new file ID. An error is
thrown if two or more pre-existing files are found.
\item \code{FALSE}: Error if there is any pre-existing file at the filepath.
}

Note that existence checks, based on filepath, are expensive operations, i.e.
they require additional API calls.}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per file.
}
\description{
Creates a shortcut to the target Drive \code{file}, which could be a folder. A
Drive shortcut functions like a symbolic or "soft" link and is primarily
useful for creating a specific Drive user experience in the browser, i.e. to
make a Drive file or folder appear in more than 1 place. Shortcuts are a
relatively new feature in Drive; they were introduced when Drive stopped
allowing a file to have more than 1 parent folder.
}
\examples{
\dontshow{if (drive_has_token()) withAutoprint(\{ # examplesIf}
# Target one of the official example files
(src_file <- drive_example_remote("chicken_sheet"))

# Create a shortcut in the default location with the default name
sc1 <- shortcut_create(src_file)
# This shortcut could now be moved, renamed, etc.

# Create a shortcut in the default location with a custom name
sc2 <- src_file |>
  shortcut_create(name = "chicken_sheet_second_shortcut")

# Create a folder, then put a shortcut there, with default name
folder <- drive_mkdir("chicken_sheet_shortcut_folder")
sc3 <- src_file |>
  shortcut_create(folder)

# Look at all these shortcuts
(dat <- drive_find("chicken_sheet", type = "shortcut"))

# Confirm the shortcuts all target the original file
dat <- dat |>
  drive_reveal("shortcut_details")
purrr::map_chr(dat$shortcut_details, "targetId")
as_id(src_file)

# Clean up
drive_rm(sc1, sc2, sc3, folder)
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \url{https://developers.google.com/drive/api/v3/shortcuts}
}
}
