% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPset.R
\name{findPset}
\alias{findPset}
\title{Find parent sets from the candidate cultivars}
\usage{
findPset(gene_df1, gene_df2, line_id)
}
\arguments{
\item{gene_df1}{Data frame of one set of haplotype. Values take 1 (target allele) or 0 (non-target).}

\item{gene_df2}{Data frame of the other set of haplotype. Values take 1 or 0.}

\item{line_id}{character vector of cultivar names}
}
\value{
`findPset()` returns a list of parental cultivar sets.
Each element of list contains the parent names.
}
\description{
Find parent sets from the candidate cultivars
}
\examples{
gene_df1 <-
 data.frame(x1 = c(1, 1, 1, 1, 1, 0, 0),
            x2 = c(1, 1, 1, 0, 1, 1, 0),
            x3 = c(1, 1, 1, 0, 1, 1, 0),
            x4 = c(1, 1, 0, 0, 0, 0, 0),
            x5 = c(0, 0, 1, 0, 1, 1, 0),
            x6 = c(0, 0, 1, 1, 0, 0, 0),
            x7 = c(0, 1, 1, 0, 0, 0, 1))
gene_df2 <-
 data.frame(x1 = c(0, 0, 0, 0, 0, 0, 0),
            x2 = c(0, 0, 0, 0, 0, 1, 0),
            x3 = c(1, 0, 0, 0, 0, 0, 0),
            x4 = c(1, 1, 0, 0, 0, 0, 0),
            x5 = c(0, 0, 1, 0, 1, 1, 0),
            x6 = c(0, 0, 1, 1, 0, 0, 0),
            x7 = c(0, 1, 1, 0, 0, 0, 1))

line_id <- c("x1", "x2", "x3", "x4", "x5", "x6", "x7")

findPset(gene_df1, gene_df2, line_id)

}
