## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(gradLasso)

## -----------------------------------------------------------------------------
set.seed(42)
# Simulate 200 obs, 20 predictors, 5 active
sim <- simulate_data(n = 200, p = 20, family = "gaussian", k = 5, snr = 3.0)
df <- data.frame(y = sim$y, sim$X)

# Check the first few rows
head(df[, 1:6])

## -----------------------------------------------------------------------------
fit <- gradLasso(y ~ ., data = df, lambda_cv = TRUE, boot = TRUE, n_boot = 50)

print(fit)

## -----------------------------------------------------------------------------
summary(fit)

## -----------------------------------------------------------------------------
# Plot Stability Selection (Plot 1) and CV Deviance (Plot 2)
plot(fit, which = c(1, 2))

## -----------------------------------------------------------------------------
set.seed(456)
sim_zinb <- simulate_data(n = 500, p = 20, family = "zinb",
                          k_mu = 5, k_pi = 5, theta = 2.0)
df_zinb <- data.frame(y = sim_zinb$y, sim_zinb$X)

## -----------------------------------------------------------------------------
# We use a smaller number of bootstraps for speed in this vignette
fit_zinb <- gradLasso(y ~ . | ., data = df_zinb,
                      family = grad_zinb(),
                      n_boot = 10,
                      lambda = 0.05) # Fixed lambda for demonstration

print(fit_zinb)

## -----------------------------------------------------------------------------
summary(fit_zinb)

## -----------------------------------------------------------------------------
# Example (not run in vignette):
# fit <- gradLasso(y ~ ., data = df, parallel = TRUE, n_cores = 4)

