% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_flights.R
\name{flightCountMatrixToConnectionList}
\alias{flightCountMatrixToConnectionList}
\title{Convert flight counts to connection list}
\usage{
flightCountMatrixToConnectionList(nFlightsPerConnection, directed = TRUE)
}
\arguments{
\item{nFlightsPerConnection}{A square, numeric matrix with identical column- and row-names.
Each entry represents the number of flights from the airport indexing the row to
the airport indexing the column in some arbitrary time period.}

\item{directed}{Logical scalar. Whether flights A->B and B->A should be considered separately.}
}
\value{
A data frame with columns \code{departureAirport}, \code{arrivalAirport}, \code{nFlights}.
Each row represents one connection with >=1 flights in the input matrix.
}
\description{
Convert a numeric matrix containing flight counts between airports to a data
frame containing a list of connections.
}
\examples{
flightCountMatrixToConnectionList(flights$flightCounts[1:100, 1:100, 1])

}
\seealso{
Other flight data related topics:
\code{\link{flights}},
\code{\link{getFlightDelayData}()},
\code{\link{getFlightGraph}()},
\code{\link{plotFlights}()}
}
\concept{flightData}
