% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_mom.R
\docType{class}
\name{MoM}
\alias{MoM}
\alias{MoMPrior-class}
\alias{MoM-class}
\alias{MoMPrior}
\title{Mixture of Multinomial Model Prior description class}
\usage{
MoMPrior(beta = 1)

MoM(alpha = 1, beta = 1)
}
\arguments{
\item{beta}{Dirichlet over vocabulary prior parameter (default to 1)}

\item{alpha}{Dirichlet prior parameter over the cluster proportions (default to 1)}
}
\value{
a \code{MoMPrior-class} object

a \code{MoM-class} object
}
\description{
An S4 class to represent a Mixture of Multinomial model.
Such model can be used to cluster a data matrix \eqn{X} with the following generative model :
\deqn{ \pi \sim Dirichlet(\alpha)}
\deqn{ Z_i  \sim \mathcal{M}(1,\pi)}
\deqn{ \theta_{k} \sim Dirichlet(\beta)}
\deqn{ X_{i.}|Z_{ik}=1 \sim \mathcal{M}(L_i,\theta_{k})}
With \eqn{L_i=\sum_d=1^DX_{id}}. These classes mainly store the prior parameters value (\eqn{\alpha,\beta}) of this generative model.
The \code{MoM-class} must be used when fitting a simple Mixture of Multinomials whereas the \code{MoMPrior-class} must be sued when fitting a \code{\link{CombinedModels-class}}.
}
\examples{
MoMPrior()
MoMPrior(beta = 0.5)
MoM()
MoM(beta = 0.5)
}
\seealso{
\code{\link{MoMFit-class}}, \code{\link{MoMPath-class}}

Other DlvmModels: 
\code{\link{CombinedModels}},
\code{\link{DcLbm}},
\code{\link{DcSbm}},
\code{\link{DiagGmm}},
\code{\link{DlvmPrior-class}},
\code{\link{Gmm}},
\code{\link{Lca}},
\code{\link{MoR}},
\code{\link{MultSbm}},
\code{\link{Sbm}},
\code{\link{greed}()}
}
\concept{DlvmModels}
