% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gremlin.R, R/mkModMats.R
\name{gremlin}
\alias{gremlin}
\alias{gremlinR}
\alias{gremlinSetup}
\alias{mkModMats}
\alias{update}
\alias{getCall.gremlin}
\alias{update.gremlin}
\title{Mixed-effect modeling functions.}
\usage{
gremlin(
  formula,
  random = NULL,
  rcov = ~units,
  data = NULL,
  ginverse = NULL,
  Gstart = NULL,
  Rstart = NULL,
  Bp = NULL,
  Gcon = NULL,
  Rcon = NULL,
  maxit = 20,
  algit = NULL,
  vit = 1,
  v = 1,
  control = gremlinControl(),
  ...
)

gremlinR(
  formula,
  random = NULL,
  rcov = ~units,
  data = NULL,
  ginverse = NULL,
  Gstart = NULL,
  Rstart = NULL,
  Bp = NULL,
  Gcon = NULL,
  Rcon = NULL,
  maxit = 20,
  algit = NULL,
  vit = 1,
  v = 1,
  control = gremlinControl(),
  ...
)

\method{getCall}{gremlin}(x, ...)

\method{update}{gremlin}(object, ...)

gremlinSetup(
  formula,
  random = NULL,
  rcov = ~units,
  data = NULL,
  ginverse = NULL,
  Gstart = NULL,
  Rstart = NULL,
  Bp = NULL,
  Gcon = NULL,
  Rcon = NULL,
  maxit = 20,
  algit = NULL,
  vit = 1,
  v = 1,
  control = gremlinControl(),
  ...
)

mkModMats(
  formula,
  random = NULL,
  rcov = ~units,
  data = NULL,
  subset = NULL,
  ginverse = NULL,
  na.action = na.pass,
  offset = NULL,
  contrasts = NULL,
  Xsparse = TRUE,
  ...
)
}
\arguments{
\item{formula}{A \code{formula} for the response variable(s) and fixed effects.}

\item{random}{A \code{formula} for the random effects.}

\item{rcov}{A \code{formula} for the residual covariance structure.}

\item{data}{A \code{data.frame} in which to look for the terms in
\code{formula}, \code{random}, and \code{rcov}.}

\item{ginverse}{A \code{list} of (preferably sparse) inverse matrices that
are proportional to the covariance structure of the random effects.
The name of each element in the list should match a column in \code{data}
that is associated with a random term. All levels of the random term should
appear as \code{rownames} for the matrices.}

\item{Gstart}{A \code{list} of matrices with starting (co)variance values for
the G-structure or random effects terms.}

\item{Rstart}{A \code{list} of matrices with starting (co)variance values for
the R-structure or residual terms.}

\item{Bp}{A prior specification for fixed effects.}

\item{Gcon, Rcon}{A \code{list} of matrices with constraint codes for the
G-structure/random effects or R-structure/residual effects terms,
respectively. Must be a \code{character} of either \code{"F"} for fixed,
\code{"P"} for positive, or \code{"U"} for unbounded.}

\item{maxit}{An \code{integer} specifying the maximum number of likelihood
iterations.}

\item{algit}{A \code{character} vector of length 1 or more or an expression
to be evaluated that specifies the algorithm to use for proposing
(co)variances in the next likelihood iteration. Mainly used to switch
between Expectation Maximization (\code{"EM"}), or Average Information
second derivatives with either (1) analytical first derivatives
(specifically \code{"AItr"}) or (2) first derivatives using a finite
difference method (backward \code{"AIbfd"}, central \code{"AIcfd"}, or
forward \code{"AIffd"} finite differences).}

\item{vit}{An \code{integer} value specifying the verbosity of screen output
on each iteration. A value of zero gives no iteration specific output and
larger values increase the amount of information printed on the screen.}

\item{v}{An \code{integer} value specifying the verbosity of screen output
regarding the model fitting process. A value of zero gives no details and
larger values increase the amount of information printed on the screen.}

\item{control}{A \code{list} returned by \code{gremlinControl} containing
specific named values from that function. See \code{\link{gremlinControl}}.}

\item{\dots}{Additional arguments to be passed to control the model fitting.}

\item{x, object}{An object of class \code{gremlin}.}

\item{subset}{An expression for the subset of \code{data} to use.}

\item{na.action}{What to do with NAs.}

\item{offset}{Should an offset be specified.}

\item{contrasts}{Specify the type of contrasts for the fixed effects.}

\item{Xsparse}{Should sparse matrices be used for the fixed effects design
matrix.}
}
\value{
A \code{list} containing an object of class \code{grMod} and, if a 
  model was fit (\code{gremlin} or \code{gremlinR}) then an object containing
  details of the REML iterations (object \code{itMat}). An object of class
  \code{grMod} contains:
  \describe{
    \item{call }{The model \code{call}.}
    \item{modMats }{A \code{list} of the model matrices used to construct the
      mixed model equations.}
      \item{y }{The response vector.}
      \item{ny }{The number of responses.}
      \item{ncy }{The number of columns of the original response.}
      \item{X }{ The fixed effects design matrix.}
      \item{nb }{The number of columns in X.}
      \item{Zr }{The residual design matrix.}
      \item{Zg }{A list of the design matrices for each random term.}
      \item{nG }{The number of parameters in the G structure.}
      \item{listGeninv }{A list of generalized inverse matrices.}
      \item{logDetG }{The log-determinants of the generalized inverse 
      matrices - necessary to calculate the log-likelihood.}

    \item{rfxIncContrib2loglik }{A \code{numeric} value containing the sum
      of the log determinants of the random effects that do not change between
      log-likelihood iterations (i.e., the part of the log determinants of 
      (co)variance matrices to be estimated that have been factored out).}
    \item{ndgeninv }{A \code{logical} indicating which terms in the random
      formula have generalized inverses associated with them (non-diagonal 
      matrices in the Kronecker product).}
    \item{dimsZg, nminffx, rfxlvls, nminfrfx }{\code{Numeric} vectors or scalars
      describing the numbers of random effects or some function of random and
      fixed effects.}
    \item{conv, bounds }{(Co)variance component constraints and boundaries
      of the allowable parameter space for each component.}
    \item{thetav }{A \code{vector} of the (co)variance parameters to
      be estimated by REML withe the attribute \dQuote{skel} giving the
      skeleton to recreate a list of \code{matrices} from this vector.}
    \item{thetaG, thetaR }{\code{Vectors} indexing the random and residual
       (co)variances, respectively, in a list of (co)variance matrices (i.e.,
       \code{theta}).}
    \item{nu }{A \code{list} of transformed (co)variance matrices
      to be fit by REML. If a residual variance has been factored out of the
      mixed model equations, \code{nu} contains the \sQuote{lambda}
      parameterization with expresses the (co)variance components as ratios
      of variance parameters with the residual variance. The \sQuote{nu} scale
      (co)variances are the ones actually fit by REML.}
    \item{sigma2e }{The estimate of the factored out residual variance from
      the mixed model equations (i.e., the \sQuote{lambda} scale)
      \eqn{\sigma^{2}_{e}}.}
    \item{p }{An \code{integer} for the total number of (co)variances to be
      estimated.}
    \item{lambda }{A \code{logical} indicating whether the \sQuote{lambda}
      scale parameterization has been used.}
    \item{uni }{A \code{logical} to indicate if the model is univariate or not.}
    \item{W, tWW, RHS, Bpinv }{Sparse matrices of class \code{Matrix} that 
      form the mixed model equations and do not change between iterations of
      REML. These are the column bound \sQuote{X} and \sQuote{Z} design
      matrices for fixed and random effects, the cross-product of \code{W},
      the Right-Hand Side of the mixed model equations, and the inverse of
      the fixed effect prior matrix (zeroes on the diagonal if no priors have
      been specified). Note, these may be \code{NULL} if \code{lambda=FALSE},
      because the \code{NULL} objects are not used or do change between
      REML iterations.}
    \item{sLc }{A \code{Matrix} containing the symbolic Cholesky factorization
      of the coefficient matrix of the Mixed Model Equations.}
    \item{sln }{A one column \code{matrix} of solutions in the mixed model
      equations.}
    \item{Cinv_ii }{A one column \code{matrix} of variances for the solutions
      to the mixed model equations. These are obtained from the diagonal of
      the inverse Coefficient matrix in the mixed model equations. If lambda
      is \code{TRUE} then these are on the lambda scale and must be
      multiplied by \code{sigma2e} to be converted to the original data scale.}
    \item{r }{A one column \code{matrix} of residual deviations, response minus
      the values expected based on the solutions, corresponding to the order
      in \code{modMats$y}.} 
    \item{AI }{A \code{matrix} of values containing the Average Information
      matrix, or second partial derivatives of the likelihood with respect to
      the transformed (co)variance components (\sQuote{nu}). The inverse of
      this matrix gives the sampling (co)variances of these transformed
      (co)variance components.}
    \item{dLdnu }{A single column \code{matrix} of first derivatives of
      the transformed (co)variance parameters (\sQuote{nu}) with respect to
      the log-Likelihood.}
    \item{maxit }{See the parameter described above.}
    \item{algit }{A \code{character} vector of REML algorithms to use in each
      iteration.}
    \item{fdit }{A \code{character} vector of which first derivative/gradient
      algorithm to use each iteration (if first derivatives of the likelihood
      function are to be calculated).}
    \item{sdit }{A \code{character} vector of which second derivative/hessian
      algorithm to use each iteration (if second derivatives of the likelihood
      function are to be calculated).}
    \item{vit }{See the parameter described above.}
    \item{v }{See the parameter described above.}
    \item{cctol }{A \code{numeric} vector of convergence criteria thresholds.
      See \code{\link{gremlinControl}} and \code{\link{ccFun}} for details.}
    \item{ezero, einf }{\code{numeric} values for the effective numbers to
      use as \dQuote{zero} and maximum negative or positive numbers. Values
      less than \code{ezero} are treated as zero and fixed to this value.
      Values less than \code{-1*einf} or greater than \code{einf} are
      restricted to these values. See \code{\link{gremlinControl}} for more
      details.}
    \item{step }{A \code{numeric} value indicating the step-reduction to use.
      See \code{\link{gremlinControl}} for more details.}
    \item{h }{A \code{numeric} value indicating the increment used in the
      first derivative (gradient) finite difference method.}

    \item{itMat }{A \code{matrix} of details about each iteration. Rows
      indicate each REML iteration (rownames reflect the REML algorithm used)
      and columns contain:
      \describe{
        \item{nu, theta}{(Co)variance parameters.}
        \item{sigma2e }{See \sQuote{sigma2e} described above.}
        \item{tyPy, logDetC }{Estimates for two these two components of the
          log of the REML likelihoods. These are obtained from Cholesky
          factorization of the coefficient matrix of the mixed model equations.}
        \item{loglik }{The REML log-likelihood.}
        \item{itTime }{Time elapsed for each REML iteration.}
      }
    }
  }
}
\description{
Fit and setup functions for linear mixed-effect model (Gaussian responses).
}
\section{Functions}{
\itemize{
\item \code{mkModMats()}: Generates model matrices.

}}
\examples{
  grSire <- gremlin(WWG11 ~ sex, random = ~ sire, data = Mrode11)
  # Now drop sire random effects and use the `anova` method to compare models
  grLM <- update(grSire, random = ~ 1)  #<-- use `~1` to drop all random effects
    anova(grSire, grLM)

  # Modular functions
  ## get model matrices for a mixed model
  mM11 <- mkModMats(WWG11 ~ sex - 1, random = ~ sire, data = Mrode11)

  ## setup model, but do not evaluate the log-likelihood
  grSetup <- gremlinSetup(WWG11 ~ sex - 1, random = ~ sire, data = Mrode11)
  ## maximize the restricted maximum likelihood
  grOut <- remlIt(grSetup)
  summary(grOut)

\dontrun{
  # Following the example from Mrode 2005, chapter 11.
  library(nadiv)  #<-- to construct inverse of the numerator relatedness matrix
  pedMrode11 <- prepPed(Mrode11[, 1:3])
  Ainv <- makeAinv(pedMrode11)$Ainv

  gr11lmm <- gremlin(WWG11 ~ sex - 1,
random = ~ calf,
data = Mrode11,
ginverse = list(calf = Ainv),
Gstart = matrix(0.2), Rstart = matrix(0.4),  #<-- specify starting values
maxit = 15,    #<-- maximum iterations
     v = 2, vit = 1,  #<-- moderate screen output (`v`) every iteration (`vit`)
     algit = "AI")  #<-- only use Average Information algorithm iterations
  summary(gr11lmm)

  # Compare the model to a Linear Model with no random effects
  ## Use `update()` to update the model
  gr11lm <- update(gr11lmm, random = ~ 1)  #<-- `~1`=drop all random effects
  summary(gr11lm)

  # Do analysis of variance between the two models
  ## See AIC or evaluate likelihood ratio against a Chi-squared distribution
  anova(gr11lm, gr11lmm)
}
}
\author{
\email{matthewwolak@gmail.com}
}
