% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmforest-control.R
\name{grmforest.control}
\alias{grmforest.control}
\title{Control Parameters for GRM Forest}
\usage{
grmforest.control(
  n_tree = 100,
  sampling = "bootstrap",
  sample_fraction = 0.632,
  mtry = NULL,
  remove_dead_trees = TRUE,
  control = grmtree.control(),
  alpha = 0.05,
  minbucket = 20,
  seed = NULL
)
}
\arguments{
\item{n_tree}{Number of trees in the forest (default: 100).}

\item{sampling}{Sampling method: "bootstrap" (with replacement) or
"subsample" (without replacement) (default: "bootstrap").}

\item{sample_fraction}{Fraction of data to sample for each tree (default:
0.632).}

\item{mtry}{Number of variables randomly sampled as candidates at each split.
If NULL, all variables are considered (default: NULL).}

\item{remove_dead_trees}{Logical indicating whether to remove trees that
encounter errors during fitting (default: TRUE).}

\item{control}{Control parameters for individual trees created by
\code{grmtree.control()}.}

\item{alpha}{Significance level for splitting (default: 0.05).}

\item{minbucket}{Minimum number of observations in terminal nodes (default:
20).}

\item{seed}{Random seed for reproducibility (default: NULL).}
}
\value{
A list of class \code{grmforest_control} containing: \item{n_tree}{Number
of trees} \item{sampling}{Sampling method} \item{sample_fraction}{Sample
fraction} \item{mtry}{Number of variables to try at each split}
\item{remove_dead_trees}{Whether to remove failed trees}
\item{control}{Tree control parameters} \item{seed}{Random seed}
}
\description{
Creates a control object for \code{grmforest} containing parameters that control
the forest growing process including sampling, tree growing, and error
handling.
}
\examples{
library(grmtree)
# Control with 50 trees using subsampling
ctrl <- grmforest.control(n_tree = 50, sampling = "subsample")

# Control with specific tree parameters
ctrl <- grmforest.control(
  control = grmtree.control(minbucket = 30, alpha = 0.01)
)

}
\seealso{
\code{\link{grmtree.control}} creates a control object for
\code{grmtree}, \code{\link{plot.grmtree}} creates plot for the \code{grmtree} object,
\code{\link{grmforest}} for GRM Forests,
}
