% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Birthwt}
\alias{Birthwt}
\title{Risk Factors Associated with Low Infant Birth Weight}
\format{
The \code{Birthwt} object is a list containing four elements (\code{X}, \code{bwt}, \code{low}, and \code{group}):
\describe{
\item{bwt}{Birth weight in kilograms}
\item{low}{Indicator of birth weight less than 2.5kg}
\item{group}{Vector describing how the columns of X are grouped}
\item{X}{A matrix with 189 observations (rows) and 16 predictor variables (columns).}
}
The matrix \code{X} contains the following columns:
\describe{
\item{age1,age2,age3}{Orthogonal polynomials of first, second, and third degree representing mother's age in years}
\item{lwt1,lwt2,lwt3}{Orthogonal polynomials of first, second, and third degree representing mother's weight in pounds at last menstrual period}
\item{white,black}{Indicator functions for mother's race; "other" is reference group}
\item{smoke}{Smoking status during pregnancy}
\item{ptl1,ptl2m}{Indicator functions for one or for two or more previous premature labors, respectively. No previous premature labors is the reference category.}
\item{ht}{History of hypertension}
\item{ui}{Presence of uterine irritability}
\item{ftv1,ftv2,ftv3m}{Indicator functions for one, for two, or for three or more physician visits during the first trimester, respectively. No visits is the reference category.}
}
}
\source{
\url{https://cran.r-project.org/package=MASS}
}
\usage{
Birthwt
}
\description{
The \code{Birthwt} data contains 189 observations, 16 predictors, and an
outcome, birthweight, available both as a continuous measure and a binary
indicator for low birth weight.The data were collected at Baystate Medical
Center, Springfield, Mass during 1986. This data frame is a
reparameterization of the \code{birthwt} data frame from the \strong{MASS} package.
}
\examples{
data(Birthwt)
hist(Birthwt$bwt, xlab="Child's birth weight", main="")
table(Birthwt$low)
## See examples in ?birthwt (MASS package)
##   for more about the data set
## See examples in ?grpreg for use of this data set
##   with group penalized regression models
}
\references{
\itemize{
\item Venables, W. N. and Ripley, B. D. (2002). \emph{Modern Applied Statistics with S.} Fourth edition. Springer.
\item Hosmer, D.W. and Lemeshow, S. (1989) \emph{Applied Logistic Regression.} New York: Wiley
}
}
\seealso{
\link[MASS:birthwt]{MASS::birthwt}, \code{\link[=grpreg]{grpreg()}}
}
\keyword{datasets}
