% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{entropic_bound}
\alias{entropic_bound}
\title{Entropic lower bounds for entropic optimal transport sensitivity indices}
\usage{
entropic_bound(
  y,
  M,
  cost = "L2",
  discrete_out = FALSE,
  solver = "sinkhorn",
  solver_optns = NULL,
  scaling = TRUE
)
}
\arguments{
\item{y}{An array or a matrix containing the output values.}

\item{M}{A scalar representing the number of partitions for continuous
inputs.}

\item{cost}{(default \code{"L2"}) A string or function defining the cost function
of the Optimal Transport problem. It should be "L2" or a function taking as
input y and returning a cost matrix. If \code{cost="L2"}, \code{ot_indices} uses the
squared Euclidean metric.}

\item{discrete_out}{(default \code{FALSE}) Logical, by default the output sample
in \code{y} are equally weighted. If \code{discrete_out=TRUE}, the function tries to
create an histogram of the realizations and to use the histogram as
weights. It works if the output is discrete or mixed and the number of
realizations is large. The advantage of this option is to reduce the
dimension of the cost matrix.}

\item{solver}{Solver for the Optimal Transport problem. Currently supported
options are:
\itemize{
\item \code{"sinkhorn"} (default), the Sinkhorn's solver \insertCite{cuturi2013sinkhorn}{gsaot}.
\item \code{"sinkhorn_log"}, the Sinkhorn's solver in log scale \insertCite{peyre2019computational}{gsaot}.
}}

\item{solver_optns}{(optional) A list containing the options for the Optimal
Transport solver. See details for allowed options and default ones.}

\item{scaling}{(default \code{TRUE}) Logical that sets whether or not to scale the
cost matrix.}
}
\value{
A scalar representing the entropic lower bound.
}
\description{
Calculate entropic lower bounds for entropic Optimal Transport sensitivity indices
}
\details{
The function allows the computation of the entropic lower bounds.
\code{solver} should be either \code{"sinkhorn"} or \code{"sinkhorn_log"}.
}
\examples{
N <- 1000

mx <- c(1, 1, 1)
Sigmax <- matrix(data = c(1, 0.5, 0.5, 0.5, 1, 0.5, 0.5, 0.5, 1), nrow = 3)

x1 <- rnorm(N)
x2 <- rnorm(N)
x3 <- rnorm(N)

x <- cbind(x1, x2, x3)
x <- mx + x \%*\% chol(Sigmax)

A <- matrix(data = c(4, -2, 1, 2, 5, -1), nrow = 2, byrow = TRUE)
y <- t(A \%*\% t(x))

M <- 25

sink_lb <- entropic_bound(y, M)

}
