## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 6,
  fig.height = 4
)
library(gvcAnalyzer)

## -----------------------------------------------------------------------------
# Countries and sectors
bm_toy_countries
bm_toy_sectors

# Dimensions
cat("Intermediate flows (Z):", paste(dim(bm_toy_Z), collapse = " × "), "\n")
cat("Final demand (Y):", paste(dim(bm_toy_Y), collapse = " × "), "\n")
cat("Value added (VA):", length(bm_toy_VA), "industries\n")
cat("Gross output (X):", length(bm_toy_X), "industries\n")

## -----------------------------------------------------------------------------
io <- bm_build_io(
  Z         = bm_toy_Z,
  Y         = bm_toy_Y,
  VA        = bm_toy_VA,
  X         = bm_toy_X,
  countries = bm_toy_countries,
  sectors   = bm_toy_sectors
)

# Structure
io$G    # number of countries
io$N    # number of sectors
io$GN   # total industries

## -----------------------------------------------------------------------------
# Single country
bm_2023_exporter_total(io, 1) # Using index 1 for China

# All countries
bm_2023_exporter_total_all(io)

## -----------------------------------------------------------------------------
# Exports from China to India
bm_2023_bilateral_source(io, 1, 2)

## -----------------------------------------------------------------------------
bm_2023_bilateral_pure(io, 1, 2)

## -----------------------------------------------------------------------------
# Single bilateral pair (China -> India)
bm_2025_tripartite_trade(io, 1, 2)

## -----------------------------------------------------------------------------
trade_comp <- bm_2025_trade_exporter(io)
trade_comp

## -----------------------------------------------------------------------------
trade_meas <- bm_2025_trade_measures(io)
trade_meas

## -----------------------------------------------------------------------------
out_comp <- bm_2025_output_components(io)
out_comp

## -----------------------------------------------------------------------------
out_meas <- bm_2025_output_measures(io)
out_meas

## -----------------------------------------------------------------------------
out_comp_sec <- bm_2025_output_components_sector(io)
head(out_comp_sec, 9)

## -----------------------------------------------------------------------------
sessionInfo()

