% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3-constructors.R, R/h3-methods.R, R/utils.R
\name{h3_from_xy}
\alias{h3_from_xy}
\alias{h3_from_points}
\alias{h3_from_strings}
\alias{h3_to_points}
\alias{h3_to_vertexes}
\alias{as.character.H3}
\alias{flatten_h3}
\alias{is_h3}
\title{Create H3 Index}
\usage{
h3_from_xy(x, y, resolution)

h3_from_points(x, resolution)

h3_from_strings(x)

h3_to_points(x)

h3_to_vertexes(x)

\method{as.character}{H3}(x, ...)

flatten_h3(x)

is_h3(x)
}
\arguments{
\item{x}{for \code{h3_from_points()} an object of class \code{sfc_POINT}. For \code{h3_from_strings()} a character vector of H3 index IDs. For \code{h3_from_xy()} a numeric vector of longitudes.}

\item{y}{a numeric vector of latitudes.}

\item{resolution}{an integer indicating the H3 cell resolution. Must be between 0 and 15 inclusive.}

\item{...}{unused.}
}
\value{
See details.
}
\description{
Create H3 indices from \code{sfc} objects, vectors of x and y coordinates, or H3 string IDs.
}
\details{
\itemize{
\item \code{h3_from_points()}: takes an \code{sfc_POINT} object and creates a vector of \code{H3} cells
\item \code{h3_from_strings()}: converts a character vector of cell indexes to an H3 vector
\item \code{h3_from_xy()}: converts vectors of \code{x} and \code{y} coordinates to an \code{H3} vector
\item \code{h3_to_points()}: converts an \code{H3} vector to a either an \code{sfc_POINT} object or a list of \code{sfg} \code{POINT} objects.
\item \code{h3_to_vertexes()}: converts an \code{H3} vector to an \code{sfc_MULTIPOINT} object or a list of \code{MULTIPOINT} objects.
}
}
\examples{
h3_from_xy(-90, 120, 5)

h3_from_strings("85f29383fffffff")

if (requireNamespace("sf")) {
  # create random points
  pnts <- sf::st_cast(
    sf::st_sfc(
      sf::st_multipoint(matrix(runif(10, max = 90), ncol = 2)),
      crs = 4326
    ),
    "POINT"
  )

  # convert to H3 objects
  h3s <- h3_from_points(pnts, 5)

  h3_to_vertexes(h3s)

  h3_to_points(h3s)
}

h3_ids <- c("831f91fffffffff", "831fb5fffffffff", "831f94fffffffff")

flatten_h3(
  list(
    NULL,
    h3_from_strings(h3_ids),
    h3_from_strings(h3_ids[1])
  )
)
}
