% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3-grid.R
\name{grid_disk}
\alias{grid_disk}
\alias{grid_ring}
\alias{grid_distances}
\alias{grid_path_cells}
\alias{grid_path_cells_size}
\alias{grid_distance}
\alias{grid_local_ij}
\title{Grid Traversal}
\usage{
grid_disk(x, k = 1, safe = TRUE)

grid_ring(x, k = 1)

grid_distances(x, k = 1)

grid_path_cells(x, y)

grid_path_cells_size(x, y)

grid_distance(x, y)

grid_local_ij(x, y)
}
\arguments{
\item{x}{an \code{H3} vector.}

\item{k}{the order of ring neighbors. 0 is the focal location (the observed H3 index). 1 is the immediate neighbors of the H3 index. 2 is the neighbors of the 1st order neighbors and so on.}

\item{safe}{default \code{TRUE}. If \code{FALSE} uses the fast algorithm which can fail.}

\item{y}{an \code{H3} vector.}
}
\value{
See details.
}
\description{
Functions used to traverse the H3 grid.
}
\details{
\itemize{
\item \code{grid_disk()}: returns the disk of cells for the identified K ring. It is a disk because it returns all cells to create a complete geometry without any holes. See \code{grid_ring()} if you do not want inclusive neighbors.
\item \code{grid_ring()}: returns a K ring of neighbors around the H3 cell.
\item \code{grid_distances()}: returns a list of numeric vectors indicating the network distances between neighbors in a K ring. The first element is always 0 as the travel distance to one's self is 0. If the H3 index is missing a 0 length vector will be returned.
\item \code{grid_path_cells()}: returns a list of \code{H3} vectors indicating the cells traversed to get from \code{x} to \code{y}. If either \code{x} or \code{y} are missing, an empty vector is returned.
\item \code{grid_path_cells_size()}: returns an integer vector with the cell path distance between pairwise elements of \code{x} and \code{y}. If either x or y are missing the result is \code{NA}.
\code{grid_distance()}: returns an integer vector with the network distance between pairwise elements of \code{x} and \code{y}. If either x or y are missing the result is \code{NA}. Effectively \code{grid_path_cells_size() - 1}.
\item \code{grid_local_ij()} returns a two column data frame containing the columns \code{i} and \code{j} which correspond to the i,j coordinate directions to the destination cell.
}
}
\examples{
h3_strs <- c("841f91dffffffff", "841fb59ffffffff")
h3 <- h3_from_strings(h3_strs)

grid_disk(h3, 1)
grid_ring(h3, 2)
grid_distances(h3, 2)
grid_path_cells(h3, rev(h3))
grid_path_cells_size(h3, rev(h3))
grid_distance(h3, rev(h3))
grid_local_ij(h3, rev(h3))
}
