% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{h3_resolution}
\alias{h3_resolution}
\alias{h3_base_cell}
\alias{is_valid_h3}
\alias{is_res_class_iii}
\alias{is_pentagon}
\alias{get_face_count}
\title{H3 Inspection Functions}
\usage{
h3_resolution(x)

h3_base_cell(x)

is_valid_h3(x)

is_res_class_iii(x)

is_pentagon(x)

get_face_count(x)
}
\arguments{
\item{x}{an \code{H3} vector.}
}
\value{
See details.
}
\description{
Functions that provide metadata about H3 indexes.
}
\details{
\itemize{
\item \code{h3_resolution()}: returns the resolution of each H3 cell.
\item \code{h3_base_cell()}: returns the base cell integer.
\item \code{is_valid_h3()}: given a vector of H3 index string IDs, determine if they are valid.
\item \code{is_res_class_iii()}: determines if an H3 cell has Class III orientation.
\item \code{is_pentagon()}: determines if an H3 cell is one of the rare few pentagons.
\item \code{get_face_count()}: returns the number of faces that intersect with the H3 index.
}
}
\examples{
cells_ids <-c(
    "85e22da7fffffff", "85e35ad3fffffff", 
    "85e22daffffffff", "85e35adbfffffff", 
    "85e22db7fffffff", "85e35e6bfffffff",
    "85e22da3fffffff"
  ) 
  
cells <- h3o::h3_from_strings(cells_ids)

h3_resolution(cells)
h3_base_cell(cells)
is_valid_h3(c("85e22db7fffffff", NA, "oopsies"))
is_res_class_iii(cells)
is_res_class_iii(h3_from_xy(0, 0, 10))
is_pentagon(h3_from_strings("08FD600000000000"))
get_face_count(cells)
}
