% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_profiles.R
\name{get_cluster_fill_rates}
\alias{get_cluster_fill_rates}
\title{Get Cluster Fill Rates}
\usage{
get_cluster_fill_rates(df)
}
\arguments{
\item{df}{A data frame of cluster assignments from \code{get_clusters_batch}.
The data frame has columns \code{docname} and \code{cluster}. Each row
corresponds to a graph and lists the document from which the graph was
obtained and the cluster to which that graph is assigned. Optionally, the
data frame might also have \code{writer} and \code{doc} columns. If present, \code{writer}
lists the writer ID of each document and \code{doc} is an identifier to
distinguish between different documents from the same writer.}
}
\value{
A data frame of cluster fill rates.
}
\description{
\code{get_cluster_fill_rates()} creates a data frame that shows the proportion of
graphs assigned to each cluster in a cluster template.
}
\examples{
docname <- c(rep("doc1", 20), rep("doc2", 20), rep("doc3", 20))
writer <- c(rep(1, 20), rep(2, 20), rep(3, 20))
doc <- c(rep(1, 20), rep(2, 20), rep(3, 20))
cluster <- sample(3, 60, replace = TRUE)
df <- data.frame(docname, writer, doc, cluster)
rates <- get_cluster_fill_rates(df)

}
