% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdMTD-methods.R
\name{hdMTD-methods}
\alias{hdMTD-methods}
\title{Methods for objects of class \code{"hdMTD"}}
\arguments{
\item{x}{An object of class \code{"hdMTD"} used in \code{print.hdMTD()}.}

\item{object}{An object of class \code{"hdMTD"} used in \code{summary.hdMTD()}.}

\item{settings}{Logical (\code{summary.hdMTD()} only). If \code{TRUE}, the
printed summary includes the method-specific \code{settings} list.
Default \code{FALSE}.}

\item{...}{Further arguments passed to or from other methods (ignored).}
}
\value{
\describe{
\item{\code{print.hdMTD}}{Invisibly returns the \code{"hdMTD"} object.}
\item{\code{summary.hdMTD}}{Invisibly returns a named list with fields:
\code{call}, \code{S}, \code{lags}, \code{A},
\code{method}, \code{d}, \code{settings}, \code{BIC_selected} and
\code{BIC_out}. Relevant information is printed to the console in
a readable format.}
}
}
\description{
Printing and summarizing methods for lag-selection results returned by
\code{\link{hdMTD}}.
}
\details{
An object of class \code{"hdMTD"} is an integer vector \eqn{S} (selected lags,
elements of \eqn{\mathbb{N}^+}) with attributes:
\itemize{
\item \code{method}: one of \code{"FS"}, \code{"FSC"}, \code{"CUT"}, \code{"BIC"}.
\item \code{d}: upper bound for the order used in the call.
\item \code{call}: the matched call that produced the object.
\item \code{settings}: a (method-specific) list of the arguments actually used.
\item \code{A}: the state space actually used (provided or inferred).
\item (optional) \code{BIC_selected_value} for \code{method="BIC"} with \code{BICvalue=TRUE}.
\item (optional) \code{extras$BIC_out} for \code{method="BIC"} (exactly the
output of \code{hdMTD_BIC()}).
}
\code{print()} shows the method, \code{d}, and the selected set of lags in
\eqn{\mathbb{N}^+}. \code{summary()} prints the call, the estimated lag
set, optional BIC diagnostics and (optionally) the method-specific settings
when \code{settings = TRUE}.
}
\examples{
\dontrun{
set.seed(1)
M <- MTDmodel(Lambda = c(1, 4), A = c(1, 3), lam0 = 0.05)
X <- perfectSample(M, N = 400)
S_hat <- hdMTD(X, d = 5, method = "FS", l = 2)
print(S_hat)
summary(S_hat)
S(S_hat); lags(S_hat)
}

}
\seealso{
\code{\link{hdMTD}}, \code{\link{hdMTD_FS}}, \code{\link{hdMTD_FSC}},
\code{\link{hdMTD_CUT}}, \code{\link{hdMTD_BIC}}, \code{\link{S}}, \code{\link{lags}}
}
