% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curepwe_logml_npp.R
\name{curepwe.logml.npp}
\alias{curepwe.logml.npp}
\title{Log marginal likelihood of a mixture cure rate (CurePWE) model under normalized power prior (NPP)}
\usage{
curepwe.logml.npp(post.samples, bridge.args = NULL)
}
\arguments{
\item{post.samples}{output from \code{\link[=curepwe.npp]{curepwe.npp()}} giving posterior samples of a CurePWE model under the normalized
power prior (NPP), with an attribute called 'data' which includes the list of variables
specified in the data block of the Stan program.}

\item{bridge.args}{a \code{list} giving arguments (other than \code{samples}, \code{log_posterior}, \code{data}, \code{lb}, and \code{ub}) to
pass onto \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}.}
}
\value{
The function returns a \code{list} with the following objects

\describe{
\item{model}{"curepwe_npp"}

\item{logml}{the estimated logarithm of the marginal likelihood}

\item{bs}{an object of class \code{bridge} or \code{bridge_list} containing the output from using \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}
to compute the logarithm of the marginal likelihood of the normalized power prior (NPP)}
}
}
\description{
Uses bridge sampling to estimate the logarithm of the marginal likelihood of a CurePWE model under the
normalized power prior (NPP).
}
\examples{
\donttest{
  if(requireNamespace("parallel")){
    library(parallel)
    ncores    = 2

    if(requireNamespace("survival")){
      library(survival)
      data(E1684)
      data(E1690)
      ## take subset for speed purposes
      E1684 = E1684[1:100, ]
      E1690 = E1690[1:50, ]
      ## replace 0 failure times with 0.50 days
      E1684$failtime[E1684$failtime == 0] = 0.50/365.25
      E1690$failtime[E1690$failtime == 0] = 0.50/365.25
      E1684$cage = as.numeric(scale(E1684$age))
      E1690$cage = as.numeric(scale(E1690$age))
      data_list = list(currdata = E1690, histdata = E1684)
      nbreaks = 3
      probs   = 1:nbreaks / nbreaks
      breaks  = as.numeric(
        quantile(E1690[E1690$failcens==1, ]$failtime, probs = probs)
      )
      breaks  = c(0, breaks)
      breaks[length(breaks)] = max(10000, 1000 * breaks[length(breaks)])
      formula = survival::Surv(failtime, failcens) ~ treatment + sex + cage + node_bin
    }

    a0 = seq(0, 1, length.out = 11)
    if (instantiate::stan_cmdstan_exists()) {
      ## call created function
      ## wrapper to obtain log normalizing constant in parallel package
      logncfun = function(a0, ...){
        hdbayes::curepwe.npp.lognc(
          formula = formula, histdata = data_list[[2]], breaks = breaks, a0 = a0,
          ...
        )
      }

      cl = makeCluster(ncores)
      clusterSetRNGStream(cl, 123)
      clusterExport(cl, varlist = c('formula', 'data_list', 'breaks'))
      a0.lognc = parLapply(
        cl = cl, X = a0, fun = logncfun, iter_warmup = 500,
        iter_sampling = 1000, chains = 1, refresh = 0
      )
      stopCluster(cl)
      a0.lognc = data.frame( do.call(rbind, a0.lognc) )

      ## sample from normalized power prior
      d.npp = curepwe.npp(
        formula = formula,
        data.list = data_list,
        a0.lognc = a0.lognc$a0,
        lognc = a0.lognc$lognc,
        breaks = breaks,
        chains = 1, iter_warmup = 500, iter_sampling = 1000,
        refresh = 0
      )
      curepwe.logml.npp(
        post.samples = d.npp,
        bridge.args = list(silent = TRUE)
      )
    }
  }
}
}
\references{
Duan, Y., Ye, K., and Smith, E. P. (2005). Evaluating water quality using power priors to incorporate historical information. Environmetrics, 17(1), 95–106.

Gronau, Q. F., Singmann, H., and Wagenmakers, E.-J. (2020). bridgesampling: An r package for estimating normalizing constants. Journal of Statistical Software, 92(10).
}
