/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5VLmodule.h" 
#define H5VL_TESTING    

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5Iprivate.h" 
#include "H5VLpkg.h"    

#include "H5VLnative_private.h" 

herr_t
H5VL__reparse_def_vol_conn_variable_test(void)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    if (H5VL__set_def_conn() < 0)
        HGOTO_ERROR(H5E_VOL, H5E_CANTINIT, FAIL, "unable to initialize default VOL connector");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

htri_t
H5VL__is_native_connector_test(hid_t vol_id)
{
    H5VL_connector_t *native, *connector;
    int               cmp_value;           
    htri_t            ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (NULL == (connector = H5I_object_verify(vol_id, H5I_VOL)))
        HGOTO_ERROR(H5E_VOL, H5E_BADTYPE, FAIL, "not a VOL connector ID");

    
    native = H5VL_NATIVE_conn_g;
    if (H5VL_cmp_connector_cls(&cmp_value, connector->cls, native->cls) < 0)
        HGOTO_ERROR(H5E_VOL, H5E_CANTCOMPARE, FAIL, "can't compare connector classes");
    ret_value = (0 == cmp_value);

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

hid_t
H5VL__register_using_vol_id_test(H5I_type_t type, void *object, hid_t vol_id)
{
    H5VL_connector_t *connector;
    hid_t             ret_value = H5I_INVALID_HID; 

    FUNC_ENTER_PACKAGE

    
    if (NULL == (connector = H5I_object_verify(vol_id, H5I_VOL)))
        HGOTO_ERROR(H5E_VOL, H5E_BADTYPE, H5I_INVALID_HID, "not a VOL connector ID");

    
    if ((ret_value = H5VL_register(type, object, connector, true)) < 0)
        HGOTO_ERROR(H5E_VOL, H5E_CANTREGISTER, H5I_INVALID_HID, "unable to get an ID for the object");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 
