% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdr.R
\name{hdr.den}
\alias{hdr.den}
\title{Density plot with Highest Density Regions}
\usage{
hdr.den(
  x,
  prob = c(0.5, 0.95, 0.99),
  den,
  h = hdrbw(BoxCox(x, lambda), mean(prob)),
  lambda = 1,
  xlab = NULL,
  ylab = "Density",
  ylim = NULL,
  plot.lines = TRUE,
  col = 2:8,
  bgcol = "gray",
  legend = FALSE,
  ...
)
}
\arguments{
\item{x}{Numeric vector containing data. If \code{x} is missing then
\code{den} must be provided, and the HDR is computed from the given density.}

\item{prob}{Probability coverage required for HDRs}

\item{den}{Density of data as list with components \code{x} and \code{y}.
If omitted, the density is estimated from \code{x} using
\code{\link[stats:density]{stats::density()}}.}

\item{h}{Optional bandwidth for calculation of density.}

\item{lambda}{Box-Cox transformation parameter where \eqn{0 \le \lambda \le 1}{0 <= lambda <= 1}.}

\item{xlab}{Label for x-axis.}

\item{ylab}{Label for y-axis.}

\item{ylim}{Limits for y-axis.}

\item{plot.lines}{If \code{TRUE}, will show how the HDRs are determined
using lines.}

\item{col}{Colours for regions.}

\item{bgcol}{Colours for the background behind the boxes. Default \code{"gray"}, if \code{NULL} no box is drawn.}

\item{legend}{If \code{TRUE} add a legend on the right of the boxes.}

\item{\dots}{Other arguments passed to plot.}
}
\value{
a list of three components: \item{hdr}{The endpoints of each interval
in each HDR} \item{mode}{The estimated mode of the density.}
\item{falpha}{The value of the density at the boundaries of each HDR.}
}
\description{
Plots univariate density with highest density regions displayed
}
\details{
Either \code{x} or \code{den} must be provided. When \code{x} is provided,
the density is estimated using kernel density estimation. A Box-Cox
transformation is used if \code{lambda!=1}, as described in Wand, Marron and
Ruppert (1991). This allows the density estimate to be non-zero only on the
positive real line. The default kernel bandwidth \code{h} is selected using
the algorithm of Samworth and Wand (2010).

Hyndman's (1996) density quantile algorithm is used for calculation.
}
\examples{
# Old faithful eruption duration times
hdr.den(faithful$eruptions)

# Simple bimodal example
x <- c(rnorm(100, 0, 1), rnorm(100, 5, 1))
hdr.den(x)
}
\references{
Hyndman, R.J. (1996) Computing and graphing highest density
regions. \emph{American Statistician}, \strong{50}, 120-126.

Samworth, R.J. and Wand, M.P. (2010). Asymptotics and optimal bandwidth
selection for highest density region estimation.  \emph{The Annals of
Statistics}, \strong{38}, 1767-1792.

Wand, M.P., Marron, J S., Ruppert, D. (1991) Transformations in density
estimation. \emph{Journal of the American Statistical Association},
\strong{86}, 343-353.
}
\seealso{
\code{\link[=hdr]{hdr()}}, \code{\link[=hdr.boxplot]{hdr.boxplot()}}
}
\author{
Rob J Hyndman
}
\keyword{distribution}
\keyword{hplot}
\keyword{smooth}
