% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-event-analysis-plot.R
\name{ts_event_analysis_plot}
\alias{ts_event_analysis_plot}
\title{Time Series Event Analysis Plot}
\usage{
ts_event_analysis_plot(
  .data,
  .plot_type = "mean",
  .plot_ci = TRUE,
  .interactive = FALSE
)
}
\arguments{
\item{.data}{The data that comes from the \code{ts_time_event_analysis_tbl()}}

\item{.plot_type}{The default is "mean" which will show the mean event change
of the output from the analysis tibble. The possible values for this are: mean,
median, and individual.}

\item{.plot_ci}{The default is TRUE. This will only work if you choose one
of the aggregate plots of either "mean" or "median"}

\item{.interactive}{The default is FALSE. TRUE will return a plotly plot.}
}
\value{
A ggplot2 object
}
\description{
Plot out the data from the \code{ts_time_event_analysis_tbl()} function.
}
\details{
This function will take in data strictly from the \code{ts_time_event_analysis_tbl()}
and plot out the data. You can choose what type of plot you want in the parameter
of \code{.plot_type}. This will give you a choice of "mean", "median", and "individual".

You can also plot the upper and lower confidence intervals if you choose one
of the aggregate plots ("mean"/"median").
}
\examples{
library(dplyr)
df <- ts_to_tbl(AirPassengers) \%>\% select(-index)

ts_time_event_analysis_tbl(
  .data = df,
  .horizon = 6,
  .date_col = date_col,
  .value_col = value,
  .direction = "both"
) \%>\%
  ts_event_analysis_plot()

ts_time_event_analysis_tbl(
  .data = df,
  .horizon = 6,
  .date_col = date_col,
  .value_col = value,
  .direction = "both"
) \%>\%
  ts_event_analysis_plot(.plot_type = "individual")

}
\seealso{
Other Plot: 
\code{\link{ts_brownian_motion_plot}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_random_walk_plot}()},
\code{\link{ts_scedacity_scatter_plot}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Plot}
