% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableSelectionNew.R
\name{FS_barplot}
\alias{FS_barplot}
\title{Feature importance bar plot}
\usage{
FS_barplot(
  data = NULL,
  grid.alpha = seq(0.01, 0.99, by = 0.01),
  missing = FALSE,
  pv_adj = "none",
  smooth.tol = 10^-12,
  method = "c"
)
}
\arguments{
\item{data}{A data frame. Values of type 'numeric' or 'integer' are treated as numerical.}

\item{grid.alpha}{A vector of alpha values to be plotted, default = seq(0.01,0.99,by=0.01).}

\item{missing}{Pairwise complete by default, set to TRUE for complete deletion.}

\item{pv_adj}{Correction method for p-value, "none" by default. For options see p.adjust.}

\item{smooth.tol}{Minimum acceptable eigenvalue for the smoothing, default 10^-12.}

\item{method}{Algorithm used. c (cell-wise) by default, r (row-wise) as the alternative.}
}
\value{
Displays a bar plot depicting which features are selected at each value
         of alpha (multiplied by 100) and a list with elements:
   \item{survivors}{Vector depicting how many alphas a variable is selected for}
   \item{data_names}{Vector depicting the corresponding names of the features}
}
\description{
Displays retained features for different
values of alpha in a bar plot.
}
\references{
Tortora C., Madhvani S., Punzo A.  (2025). Designing unsupervised mixed-type
feature selection techniques using the
heterogeneous correlation matrix. International Statistical Review.
https://doi.org/10.1111/insr.70016
}
\examples{
\donttest{ 
data(ESI)
data=ESI[,-c(1,3,4,6,9)]##removing categorical features
FS_barplot(data, pv_adj='BH') #using BH adkustment for the p-values
}
}
