% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liquidityMeasures.R
\name{getTradeDirection}
\alias{getTradeDirection}
\title{Get trade direction}
\usage{
getTradeDirection(tqData)
}
\arguments{
\item{tqData}{\code{data.table} or \code{xts} object, containing joined trades and quotes (e.g. using \code{\link{matchTradesQuotes}})}
}
\value{
A vector which has values 1 or (-1) if the inferred trade direction
is buy or sell respectively.
}
\description{
Function returns a vector with the inferred trade direction which is 
determined using the Lee and Ready algorithm (Lee and Ready, 1991).
}
\details{
NOTE: By convention the first observation is always marked as a buy.
}
\examples{
\dontshow{if (!grepl("debian", sessionInfo()["platform"], fixed = TRUE)) withAutoprint(\{ # examplesIf}
# Generate matched trades and quote data set
tqData <- matchTradesQuotes(sampleTData[as.Date(DT) == "2018-01-02"], 
                            sampleQData[as.Date(DT) == "2018-01-02"])
directions <- getTradeDirection(tqData)
head(directions)
\dontshow{\}) # examplesIf}
}
\references{
Lee, C. M. C. and Ready, M. J. (1991). Inferring trade direction from intraday data. \emph{Journal of Finance}, 46, 733-746.
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup. Special thanks to Dirk Eddelbuettel.
}
\keyword{liquidity}
