% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{make_route_envelope}
\alias{make_route_envelope}
\title{Make range-constrained envelope between 2 airports}
\usage{
make_route_envelope(ac, ap2, envelope_points = 200, fuzz = 0.005)
}
\arguments{
\item{ac, ap2}{See \code{\link{find_route}}}

\item{envelope_points}{How many points are used to define the ellipse? Default
200.}

\item{fuzz}{Add a little margin to the range, to allow the longest range to
be flown, rather than be cut off at the boundary. (Default 0.005)}
}
\value{
\code{sf POLYGON} with ad hoc coordinate reference system.
}
\description{
\code{make_route_envelope} finds the range envelope for a given route
}
\details{
The 'route envelope' is the region within which a route from A to B must
remain. This is an ellipse.

It differs from the pure 'range envelope' which is the points which an
aircraft can reach from a given airport.
}
\examples{
# Need aircraft and airport datasets
ac <- make_aircraft(warn = FALSE)
ap <- make_airports()
z <- make_route_envelope(ac[1,], make_AP2("EGLL","KJFK",ap))

}
