% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hb_s_tau.R
\name{hb_s_tau}
\alias{hb_s_tau}
\title{Superseded suggest s_tau given a uniform prior on tau.}
\usage{
hb_s_tau(precision_ratio = 0.5, sigma = 1, n = 100)
}
\arguments{
\item{precision_ratio}{Positive numeric vector of elements between 0 and 1
with target precision ratios.}

\item{sigma}{Positive numeric vector of residual standard deviations.}

\item{n}{Number of non-missing patients.}
}
\value{
Numeric of length equal to \code{length(precision_ratio)} and
\code{length(sigma)}, suggested values of s_tau for each element of
\code{precision_ratio} and \code{sigma}.
}
\description{
For the uniform prior on tau,
suggest a value of the \code{s_tau} hyperparameter
to achieve a given amount of borrowing in the hierarchical model.
Only use if a diffuse prior on \code{tau} is not feasible.
}
\details{
See the hierarchical model section of the
methods vignette for details.
}
\examples{
hb_s_tau(precision_ratio = 0.5, sigma = 1, n = 100)
}
\keyword{internal}
