% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voting.R
\name{voting}
\alias{voting}
\title{Function to simulate the voting process}
\usage{
voting(
  voters,
  nominated,
  n_votes,
  gamma_val,
  gamma_rank,
  epsilon,
  free = TRUE,
  closed_primary = FALSE,
  strategic = FALSE,
  strategic_error = 0.05,
  party_pos = NULL
)
}
\arguments{
\item{voters}{See \code{\link[=simulate_election]{simulate_election()}}.}

\item{nominated}{See \code{\link[=simulate_election]{simulate_election()}}.}

\item{n_votes}{See \code{\link[=simulate_election]{simulate_election()}}.}

\item{gamma_val}{See \code{\link[=simulate_election]{simulate_election()}}.}

\item{gamma_rank}{See \code{\link[=simulate_election]{simulate_election()}}.}

\item{epsilon}{Numeric; maximum acceptable ideological distance used in voters' utility function}

\item{free}{See \code{\link[=simulate_election]{simulate_election()}}. Defaults to \code{TRUE}.}

\item{closed_primary}{Boolean: Are voters required to vote for a candidate in the party closest to them in the primary? Defaults to \code{FALSE}.}

\item{strategic}{See \code{\link[=simulate_election]{simulate_election()}}.}

\item{strategic_error}{See \code{\link[=simulate_election]{simulate_election()}}. Defaults to 0.05}

\item{party_pos}{Locations of parties in the election in 1d space (-2, 2).}
}
\value{
List with two elements:
\describe{
\item{votes}{Matrix with \code{n_votes} rows and \code{length(voters)} columns, with cells populated with candidate IDs}
\item{max_utils}{Vector of maximum utilities received by each voter from among all candidates in the election}
}
}
\description{
Internal function.
}
