% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonplot.R
\name{seasonplot}
\alias{seasonplot}
\title{Plot seasonal subseries from a time series}
\usage{
seasonplot(x, ...)
}
\arguments{
\item{x}{An `inzightts` (`inz_ts`) object representing the time series.}

\item{...}{Further arguments to be passed onto specific methods and the
`gg_season` function.}
}
\value{
A `patchwork` object of seasonal plots.
}
\description{
This function plots the seasonal components of a time series together
with the estimated seasonal effects of that series.
}
\details{
The resulting window will contain two plots. On the left, every
seasonal subseries of the time series is plotted. On the right will be
the average seasonal effect of the series.
}
\examples{
\dontrun{
seasonplot(inzightts(visitorsQ))
}

}
\seealso{
\code{\link[feasts]{gg_season}}
}
