% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_cibd.R
\name{r_cibd}
\alias{r_cibd}
\title{Random generation for IBD on a continuous genome}
\usage{
r_cibd(
  n,
  pedigree,
  ids = pedtools::leaves(pedigree),
  states = "ibd",
  ibd_state = 1L,
  chromosome_length = 267.77
)
}
\arguments{
\item{n}{Number of observations}

\item{pedigree}{Pedigree in \code{\link[pedtools:ped]{pedtools::ped}} form.}

\item{ids}{Ids for which IBD is observed. Default is \code{pedtools::leaves(pedigree)}.}

\item{states}{One of \verb{"ibd} (default), \code{"kappa"}, \code{"identity"} or \code{"detailed"}.}

\item{ibd_state}{Default is 1.}

\item{chromosome_length}{Default is 267.77 cM (an estimate of the length of chromosome 1).}
}
\value{
A list containing:
\item{samples}{Data frame of simulated IBD segments along the chromosome.}
\item{stats}{Data frame with summary statistics per sample,
including total IBD length and the segment count.}
}
\description{
The \code{r_cibd} function generates random Identity-by-Descent (IBD) segments
along a continuous genome, given a specified pedigree and observed
individuals.
}
\examples{
## Basic example: IBD along one chromosome for half siblings
L <- 300
r_hs <- r_cibd(n = 1e4, pedigree = pedtools::halfSibPed(), chromosome_length = 300)

# half sibs alternate between IBD (state 1) and not IBD (state 0)
head(r_hs$samples)

# the total_length and number of segments per sample are also returned
head(r_hs$stats)

## Comparing half siblings and grandparent-grandchild
r_gp <- r_cibd(n = 1e4, pedigree = pedtools::linearPed(2), ids = c(1, 5),
               chromosome_length = 300)

hist(r_gp$stats$total_length)
hist(r_hs$stats$total_length)
}
