% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-docs.R, R/fst.R, R/ini.R, R/json.R,
%   R/mat.R, R/yaml.R
\name{low-level-read-write}
\alias{low-level-read-write}
\alias{io_read_fst}
\alias{io_write_fst}
\alias{io_read_ini}
\alias{io_read_json}
\alias{io_write_json}
\alias{io_read_mat}
\alias{io_write_mat}
\alias{io_read_yaml}
\alias{io_write_yaml}
\title{Low-level file read and write}
\usage{
io_read_fst(
  con,
  method = c("proxy", "data_table", "data_frame", "header_only"),
  ...,
  old_format = FALSE
)

io_write_fst(x, con, compress = 50, ...)

io_read_ini(con, ...)

io_read_json(con, ...)

io_write_json(
  x,
  con = stdout(),
  ...,
  digits = ceiling(-log10(.Machine$double.eps)),
  pretty = TRUE,
  serialize = TRUE
)

io_read_mat(
  con,
  method = c("auto", "R.matlab", "pymatreader", "mat73"),
  verbose = TRUE,
  on_convert_error = c("warning", "error", "ignore"),
  ...
)

io_write_mat(x, con, method = c("R.matlab", "scipy"), ...)

io_read_yaml(con, ...)

io_write_yaml(x, con, ..., sorted = FALSE)
}
\arguments{
\item{con}{connection or file}

\item{method}{method to read table. For \code{'fst'}, the choices are
\describe{
\item{\code{'proxy'}}{do not read data to memory, query the table when
needed;}
\item{\code{'data_table'}}{read as \code{\link[data.table]{data.table}};}
\item{\code{'data_frame'}}{read as \code{\link{data.frame}};}
\item{\code{'header_only'}}{read \code{'fst'} table header.}
}
For \code{'mat'}, the choices are
\describe{
\item{\code{'auto'}}{automatically try the native option, and then
\code{'pymatreader'} if fails;}
\item{\code{'R.matlab'}}{use the native method (provided
by \code{\link[R.matlab]{readMat}}); only support 'MAT 5.0' format;}
\item{\code{'pymatreader'}}{use 'Python' library \code{'pymatreader'};}
\item{\code{'mat73'}}{use 'Python' library \code{'mat73'}.}
}}

\item{...}{passed to internal function calls}

\item{old_format}{see \code{\link[fst]{fst}}}

\item{x}{data to write to disk}

\item{compress}{compress level from 0 to 100; default is 50}

\item{digits, pretty}{for writing numeric values to 'json' format}

\item{serialize}{set to \code{TRUE} to serialize the data to 'json' format
(with the data types, default); or \code{FALSE} to save the
values without types}

\item{verbose}{whether to print out the process}

\item{on_convert_error}{for reading \code{'mat'} files with 'Python' modules,
the results will be converted to R objects in the end. Not all objects
can be converted. This input defines the behavior when the conversion fails;
choices are \code{"error"}, \code{"warning"}, or \code{"ignore"}}

\item{sorted}{whether to sort the list; default is \code{FALSE}}
}
\value{
The reader functions returns the data extracted from files, mostly
as R objects, with few exceptions on some 'Matlab' files. When reading a
'Matlab' file requires using 'Python' modules, \code{io_read_mat} will
try its best effort to convert 'Python' objects to R. However, such
conversion might fail. In this case, the result might partially contain
'Python' objects with warnings.
}
\description{
Interfaces to read from or write to files with common formats.
}
\examples{

# ---- fst ----------------------------------------------------------------


f <- tempfile(fileext = ".fst")
x <- data.frame(
  a = 1:10,
  b = rnorm(10),
  c = letters[1:10]
)

io_write_fst(x, con = f)

# default reads in proxy
io_read_fst(f)

# load as data.table
io_read_fst(f, "data_table")

# load as data.frame
io_read_fst(f, "data_frame")

# get header
io_read_fst(f, "header_only")

# clean up
unlink(f)



# ---- json ---------------------------------------------------------------
f <- tempfile(fileext = ".json")

x <- list(a = 1L, b = 2.3, c = "a", d = 1+1i)

# default is serialize
io_write_json(x, f)

io_read_json(f)

cat(readLines(f), sep = "\n")

# just values
io_write_json(x, f, serialize = FALSE, pretty = FALSE)

io_read_json(f)

cat(readLines(f), sep = "\n")

# clean up
unlink(f)



# ---- Matlab .mat --------------------------------------------------------

\dontrun{

f <- tempfile(fileext = ".mat")

x <- list(a = 1L, b = 2.3, c = "a", d = 1+1i)

# save as MAT 5.0
io_write_mat(x, f)

io_read_mat(f)

# require setting up Python environment

io_read_mat(f, method = "pymatreader")

# MAT 7.3 example
sample_data <- ieegio_sample_data("mat_v73.mat")
io_read_mat(sample_data)

# clean up
unlink(f)

}



# ---- yaml ---------------------------------------------------------------

f <- tempfile(fileext = ".yaml")

x <- list(a = 1L, b = 2.3, c = "a")
io_write_yaml(x, f)

io_read_yaml(f)

# clean up
unlink(f)

}
