% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ife.R, R/influence_func_estimand.R
\name{ife}
\alias{ife}
\alias{ife_constructor}
\alias{influence_func_estimate}
\title{Create a new `influence_func_estimate` object}
\usage{
ife(
  x,
  eif,
  weights = rep(1, length(eif)),
  id = as.character(1:length(eif)),
  critical_value = qnorm(0.975)
)

influence_func_estimate(
  x,
  eif,
  weights = rep(1, length(eif)),
  id = as.character(1:length(eif)),
  critical_value = qnorm(0.975)
)
}
\arguments{
\item{x}{[\code{numeric(1)}]\cr
The estimate.}

\item{eif}{[\code{numeric(n)}]\cr
The influence function.}

\item{weights}{[\code{numeric(n)}]\cr
Optional sampling weights.}

\item{id}{[\code{character(n)}]\cr
Optional cluster identifiers.}

\item{critical_value}{[\code{numeric(1)}]\cr
Optional critical value for constructing confidence interval.}
}
\value{
An 'S7' object of class \code{influence_func_estimate}.
}
\description{
Create a new `influence_func_estimate` object
}
\examples{
x <- influence_func_estimate(5, runif(10))
y <- ife(5, runif(10))
x + y
x + 1
1 - y
x / y
x * y
tidy(x)
}
