nnglobalsearch <- function(rsim, l, u, data, ctrl) {
    p <- data$p
    q <- data$q
    ninit <- ctrl$Ninit
    n <- data$n
    N <- ctrl$NTotglobal
    nelite <- ctrl$Nelite
    Aelite <- ctrl$Aelite
    add <- ctrl$NAddglobal
    tol <- ctrl$Tolglobal
    nextreport <- trace <- ctrl$trace
    while (1) {
        ## estimation of bind function and weight matrix
        idx <- seq.int(n)
        par <- (data$par[, idx, drop=FALSE] - l) / (u - l)
        shat <- knnreg(par, data$stat[, idx, drop=FALSE], par)
        sc <- isqm(fastrob(data$stat[, idx, drop=FALSE] - shat))
        # ## elite sample
        elite <- floor(nelite + (n-nelite) * Aelite^((n/ninit)^2)) 
        e <- data$par[, knnsearch0(sc %*% shat, elite), drop=FALSE]
        em <- rowMeans(e)
        C <- tcrossprod((e - em) / sqrt(elite))
        es <- sqrt(diag(C))
        ## report and check convergence
        done <- (n >= N) || all(es < tol * pmax(1, abs(em)))
        if ((trace > 0) && (done || (n >= nextreport))) {
            cat(
                "After", n, "simulations (global search)\n",
                " elite sample size:", elite, "\n",
                " guess:   ", em, "\n",
                " elite sd:", es, "\n"
            )
            nextreport <- n + trace
        }
        if (done) break
        ## add new points
        mn <- min(N - n, add)
        idx <- seq.int(n + 1, n + mn)
        S <- sqm(C)
        data$par[, idx] <- replicate(mn, tnorm(p, e[, sample.int(elite, 1)], S, l, u))
        data$stat[, idx] <-
            if (is.null(data$cl)) {
                apply(data$par[, idx, drop = FALSE], 2, rsim)
            } else {
                parallel::parCapply(data$cl, data$par[, idx, drop = FALSE], rsim)
            }
        n <- n + mn
    }
    data$n <- n
    e[,1]
}

