% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/trait.R
\name{trait-model}
\alias{trait-model}
\alias{traitSim}
\alias{trait}
\alias{traitStat}
\title{Jabot's trait model}
\usage{
traitSim(theta, nspecies = 1000L, population = 500L, ngen = 5000L)

traitStat(n, q = c(0.01, seq(0.05, 0.95, by = 0.05), 0.99))
}
\arguments{
\item{theta}{a vector of length 4 containing the model parameters,}

\item{nspecies}{the number of different levels of the trait
characteristic (default 1000)}

\item{population}{number of individuals living in the community
(default 500)}

\item{ngen}{number of generations (death/birth cycles) after which the
actual population is returned (default 5000)}

\item{n}{the observed data}

\item{q}{the quantiles used to summarize the trait distribution}
}
\value{
\code{traitSim} returns a integer vector of length \code{nspecies} containing the trait distribution
of \code{population} individuals after \code{ngen} generations

\code{traitStat} returns a numeric vector containing the species richness
(i.e., the number of distinct traits in the population),
the Gini index, and the quantiles of the trait
characteristic corresponding to the input arguments \code{q}
}
\description{
Function \code{traitSim} (written in C++) simulates a realization from
the trait model suggested by Jabot (2010); function \code{traiStat}
computes a possible summary statistics.
}
\details{
The model describes the distribution of a numeric trait in a population
of size \code{population}. The trait can only assume the values
\eqn{(i-1)/(nspecies-1)} for \eqn{i=1,...,nspecies}. The local
competitive ability of a species with trait \code{u} is proportional to
\deqn{F(u)=1-\omega+\omega\phi(u; \mu, \sigma)} where \eqn{\omega},
\eqn{\mu} and \eqn{\sigma} are parameters, and \eqn{\phi(u;\mu,
\sigma)} denotes the probability density function of a normal random variable with mean
\eqn{\mu} and variance \eqn{\sigma^2}.

The traits of the initial
population are randomly drawn with probability proportional to
\eqn{F(u)}. Then, for \code{ngen} steps, one individual randomly chosen
dies. It is replaced either by an immigrant (with probability
\eqn{\gamma}) or by a descendant of another randomly choosen existing
individual (with probability \eqn{1-\gamma}).
In the first case (immigration), the trait of the new individual is drawn with
probability proportional to \eqn{F(u)}. In the second case
(reproduction), the the probability that the trait of
the new individual is \code{u} is proportional to the abundance of \code{u} in the
population times \eqn{F(u)}.

The vector of model parameters is \eqn{\theta=(\gamma, \mu, \sigma, \omega)'}.
Note that the parametrization used in this package differs from the one
originally suggested  by Jabot (2010). Specifically, Jabot assumes that
\eqn{\gamma=J/(J+population-1)} and
\eqn{F(u)=1+2A\pi\sigma\phi(u;\mu, \sigma)}
where \eqn{J} and \eqn{A} are alternative parameters used in place of
\eqn{\gamma} and \eqn{\omega}, respectively.
}
\examples{
set.seed(1)
theta <- c(0.2, 0.7, 0.2, 0.7)
y <- traitSim(theta)
plot(seq(0, 1, length = length(y)), y, type = "h", xlab = "trait", ylab = "frequency")
print(tobs <- traitStat(y))
\donttest{
# It takes some time to run
tsim <- function(theta) traitStat(traitSim(theta))
m <- ifit(tobs, tsim, l = rep(0, 4), u = rep(1, 4), trace = 1000)
m
confint(m)
diagIFIT(m)
numsimIFIT(m)
}
}
\references{
Franck Jabot (2010) 'A Stochastic Dispersal-Limited Trait-Based Model of
Community Dynamics', Journal of Theoretical Biology,  262, pp.
650–61, \doi{10.1016/j.jtbi.2009.11.004}.
}
\keyword{model}
