% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_node_degrees.R
\name{plot_node_degrees}
\alias{plot_node_degrees}
\title{Visualize Node Degree Distribution in a Network Graph}
\usage{
plot_node_degrees(graph)
}
\arguments{
\item{graph}{An \code{igraph} object. Can be either directed or undirected.}
}
\value{
A \code{ggplot} object:
\itemize{
  \item \strong{Undirected graphs:} A bar for each node showing its total degree.
  \item \strong{Directed graphs:} Split bars per node with negative values for in‐degree
        (pointing left) and positive values for out‐degree (pointing right).
}
}
\description{
Generates a horizontal bar‐style plot of node degrees for an \code{igraph} network.
For undirected graphs, it shows each node’s total degree.
For directed graphs, it displays in‐degrees (as negative bars) alongside out‐degrees.
}
\details{
This function computes:
\describe{
  \item{Total degree}{Number of edges incident on each node (for undirected graphs).}
  \item{In‐degree}{Number of incoming edges per node (for directed graphs).}
  \item{Out‐degree}{Number of outgoing edges per node (for directed graphs).}
}
For directed graphs, in‐degrees are negated so that bars extend leftward,
providing an immediate visual comparison to out‐degrees.

Internally, it uses:
\itemize{
  \item \code{igraph::degree()} to compute degrees,
  \item \code{dplyr} and \code{tidyr} for reshaping the data,
  \item \code{ggplot2} for plotting.
}
}
\section{Customization}{

You can modify the returned \code{ggplot} with additional layers, themes, or labels.
For example, to add a title or change colors:
\preformatted{
plot_node_degrees(g) +
  ggtitle("Degree Distribution") +
  scale_fill_manual(values = c("in_degree" = "steelblue", "out_degree" = "salmon"))
}
}

\examples{
library(ig.degree.betweenness)
library(igraphdata)
data("karate")
data("oncology_network")
plot_node_degrees(oncology_network)
plot_node_degrees(karate)
}
