% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{image_load}
\alias{image_load}
\title{Load PNG, JPG, BMP or GIF}
\usage{
image_load(file)
}
\arguments{
\item{file}{character, file name. A local file or URL. Extension must be one of
\code{png}, \code{jpg}, \code{jpeg}, \code{bmp} or \code{gif}.}
}
\value{
an RBG array
}
\description{
Load PNG, JPG, BMP or GIF from disk or URL.
}
\details{
The function will prompt you of the need to install a format-specific package
if not installed and needed for the given \code{file} extension; \code{png}, \code{bmp},
\code{magick} (for GIF). \code{jpeg} is already imported for purpose of running examples.
}
\examples{
x <- paste0(system.file(package = "imgpalr"), "/blue-yellow.",
  c("jpg", "png", "bmp", "gif"))
str(image_load(x[1]))
if(require(png)) str(image_load(x[2]))
if(require(bmp)) str(image_load(x[3]))
if(require(magick)) str(image_load(x[4]))
}
