% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_public.R
\name{pubRep}
\alias{pubRep}
\alias{publicRepertoire}
\title{Create a repertoire of public clonotypes}
\usage{
pubRep(
  .data,
  .col = "aa+v",
  .quant = c("count", "prop"),
  .coding = TRUE,
  .min.samples = 1,
  .max.samples = NA,
  .verbose = TRUE
)
}
\arguments{
\item{.data}{The data to be processed. Can be \link{data.frame},
\link[data.table:data.table]{data.table::data.table}, or a list of these objects.

Every object must have columns in the immunarch compatible format.
\link{immunarch_data_format}

Competent users may provide advanced data representations:
DBI database connections, or a list
of these objects. They are supported with the same limitations as basic objects.

Note: each connection must represent a separate repertoire.}

\item{.col}{A string that specifies the column(s) to be processed. Outputs one of the
following strings, separated by the plus sign: "nt" for nucleotide sequences,
"aa" for amino acid sequences, "v" for V gene segments, "j" for J gene segments. E.g.,
pass "aa+v" to compute overlaps on CDR3 amino acid sequences paired with V gene segments, i.e.,
in this case a unique clonotype is a pair of CDR3 amino acid and V gene segment.}

\item{.quant}{A string that specifies the column to be processed. Set "count" to see
public clonotype sharing with the number of clones, set "prop" to see proportions.}

\item{.coding}{Logical. If TRUE then preprocesses the data to filter out non-coding sequences.}

\item{.min.samples}{Integer. A minimal number of samples a clonotype must have to be included
in the public repertoire table.}

\item{.max.samples}{Integer. A maxminal number of samples a clonotype must have to be included
in the public repertoire table. Set NA (by default) to have the maximal amount of samples.}

\item{.verbose}{Logical. If TRUE then outputs the progress.}
}
\value{
Data table with columns for:
\itemize{
\item Clonotypes (e.g., CDR3 sequence, or two columns for CDR3 sequence and V gene)
\item Incidence of clonotypes
\item Per-sample proportions or counts
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
# Subset the data to make the example faster to run
immdata$data <- lapply(immdata$data, head, 2000)
pr <- pubRep(immdata$data, .verbose = FALSE)
vis(pr, "clonotypes", 1, 2)
}
\concept{pubrep}
