% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomize.R
\docType{class}
\name{randomizer}
\alias{randomizer}
\title{Randomization Class for Treatment Assignment}
\description{
This class provides methods to randomly assign treatments
to a dataset while ensuring baseline covariate balance. It can
handle both simple and stratified randomization.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{version}}{The version of the \code{im} package used for randomization.}

\item{\code{data}}{The data frame with the assigned treatment.}

\item{\code{seed}}{The random seed used for reproducibility.}

\item{\code{balance_summary}}{A summary (or list of summaries) of the balance
assessment after randomization.}

\item{\code{balance_plot}}{A plot (or list of plots) of the balance assessment
after randomization.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-randomized-new}{\code{randomizer$new()}}
\item \href{#method-randomized-clone}{\code{randomizer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-randomized-new"></a>}}
\if{latex}{\out{\hypertarget{method-randomized-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new Randomizer object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{randomizer$new(
  data,
  variables,
  standard = "Not Concerned",
  seed = NULL,
  max_attempts = 100,
  group_by = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The input data frame.}

\item{\code{variables}}{A vector of covariate names to check for balance.}

\item{\code{standard}}{The desired level of baseline equivalence.
Must be one of "Not Concerned",
"Concerned", or "Very Concerned". Default is "Not Concerned".
("Not Concerned", "Concerned", or "Very Concerned").}

\item{\code{seed}}{(Optional) An integer to set the random seed.}

\item{\code{max_attempts}}{(Optional) Maximum number of randomization attempts.}

\item{\code{group_by}}{(Optional) A character vector of column names to
stratify randomization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{randomizer} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-randomized-clone"></a>}}
\if{latex}{\out{\hypertarget{method-randomized-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{randomizer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
