// Generated by rstantools.  Do not edit by hand.

/*
    im is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    im is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with im.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_logit_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 61> locations_array__ =
  {" (found before start of program)",
  " (in 'logit', line 39, column 2 to column 13)",
  " (in 'logit', line 40, column 2 to column 17)",
  " (in 'logit', line 41, column 2 to column 11)",
  " (in 'logit', line 60, column 2 to column 18)",
  " (in 'logit', line 61, column 2 to column 15)",
  " (in 'logit', line 62, column 2 to column 15)",
  " (in 'logit', line 63, column 2 to column 11)",
  " (in 'logit', line 64, column 2 to column 18)",
  " (in 'logit', line 66, column 4 to line 67, column 35)",
  " (in 'logit', line 68, column 4 to column 69)",
  " (in 'logit', line 69, column 4 to column 75)",
  " (in 'logit', line 65, column 17 to line 70, column 5)",
  " (in 'logit', line 65, column 2 to line 70, column 5)",
  " (in 'logit', line 71, column 2 to column 28)",
  " (in 'logit', line 72, column 2 to column 27)",
  " (in 'logit', line 44, column 9 to column 10)",
  " (in 'logit', line 44, column 2 to column 18)",
  " (in 'logit', line 46, column 2 to column 39)",
  " (in 'logit', line 48, column 4 to column 47)",
  " (in 'logit', line 47, column 17 to line 49, column 3)",
  " (in 'logit', line 47, column 2 to line 49, column 3)",
  " (in 'logit', line 50, column 2 to column 33)",
  " (in 'logit', line 51, column 2 to column 45)",
  " (in 'logit', line 54, column 6 to column 33)",
  " (in 'logit', line 52, column 25 to line 57, column 3)",
  " (in 'logit', line 52, column 2 to line 57, column 3)",
  " (in 'logit', line 14, column 2 to column 8)",
  " (in 'logit', line 15, column 30 to column 31)",
  " (in 'logit', line 15, column 2 to column 33)",
  " (in 'logit', line 16, column 2 to column 8)",
  " (in 'logit', line 17, column 9 to column 10)",
  " (in 'logit', line 17, column 12 to column 13)",
  " (in 'logit', line 17, column 2 to column 17)",
  " (in 'logit', line 18, column 2 to column 18)",
  " (in 'logit', line 19, column 2 to column 16)",
  " (in 'logit', line 20, column 9 to column 10)",
  " (in 'logit', line 20, column 2 to column 22)",
  " (in 'logit', line 21, column 9 to column 10)",
  " (in 'logit', line 21, column 2 to column 20)",
  " (in 'logit', line 22, column 9 to column 10)",
  " (in 'logit', line 22, column 2 to column 18)",
  " (in 'logit', line 23, column 2 to column 16)",
  " (in 'logit', line 24, column 2 to column 23)",
  " (in 'logit', line 26, column 2 to column 39)",
  " (in 'logit', line 29, column 9 to column 10)",
  " (in 'logit', line 29, column 12 to column 13)",
  " (in 'logit', line 29, column 2 to column 21)",
  " (in 'logit', line 30, column 9 to column 10)",
  " (in 'logit', line 30, column 2 to column 19)",
  " (in 'logit', line 31, column 9 to column 10)",
  " (in 'logit', line 31, column 2 to column 17)",
  " (in 'logit', line 33, column 4 to column 28)",
  " (in 'logit', line 34, column 4 to column 24)",
  " (in 'logit', line 35, column 4 to column 46)",
  " (in 'logit', line 32, column 17 to line 36, column 3)",
  " (in 'logit', line 32, column 2 to line 36, column 3)",
  " (in 'logit', line 40, column 9 to column 10)",
  " (in 'logit', line 60, column 9 to column 10)",
  " (in 'logit', line 61, column 9 to column 10)",
  " (in 'logit', line 62, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_logit final : public model_base_crtp<model_logit> {
private:
  int N;
  std::vector<int> y;
  int K;
  Eigen::Matrix<double,-1,-1> X_data__;
  double mean_alpha;
  double sd_alpha;
  Eigen::Matrix<double,-1,1> mean_beta_data__;
  Eigen::Matrix<double,-1,1> sd_beta_data__;
  Eigen::Matrix<double,-1,1> treat_data__;
  double tau_mean;
  double tau_sd;
  int run_estimation;
  Eigen::Matrix<double,-1,-1> X_std_data__;
  Eigen::Matrix<double,-1,1> mean_X_data__;
  Eigen::Matrix<double,-1,1> sd_X_data__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> mean_beta{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> sd_beta{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> treat{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X_std{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> mean_X{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> sd_X{nullptr, 0};
public:
  ~model_logit() {}
  model_logit(stan::io::var_context& context__, unsigned int
              random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_logit_namespace::model_logit";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 27;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 27;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 28;
      stan::math::validate_non_negative_index("y", "N", N);
      current_statement__ = 29;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      y = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 29;
      y = context__.vals_i("y");
      current_statement__ = 29;
      stan::math::check_greater_or_equal(function__, "y", y, 0);
      current_statement__ = 29;
      stan::math::check_less_or_equal(function__, "y", y, 1);
      current_statement__ = 30;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 30;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 31;
      stan::math::validate_non_negative_index("X", "N", N);
      current_statement__ = 32;
      stan::math::validate_non_negative_index("X", "K", K);
      current_statement__ = 33;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(K)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, K,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), N, K);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 33;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 33;
        pos__ = 1;
        current_statement__ = 33;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 33;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 33;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 33;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 34;
      context__.validate_dims("data initialization", "mean_alpha", "double",
        std::vector<size_t>{});
      mean_alpha = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 34;
      mean_alpha = context__.vals_r("mean_alpha")[(1 - 1)];
      current_statement__ = 35;
      context__.validate_dims("data initialization", "sd_alpha", "double",
        std::vector<size_t>{});
      sd_alpha = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 35;
      sd_alpha = context__.vals_r("sd_alpha")[(1 - 1)];
      current_statement__ = 36;
      stan::math::validate_non_negative_index("mean_beta", "K", K);
      current_statement__ = 37;
      context__.validate_dims("data initialization", "mean_beta", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      mean_beta_data__ = Eigen::Matrix<double,-1,1>::Constant(K,
                           std::numeric_limits<double>::quiet_NaN());
      new (&mean_beta)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(mean_beta_data__.data(), K);
      {
        std::vector<local_scalar_t__> mean_beta_flat__;
        current_statement__ = 37;
        mean_beta_flat__ = context__.vals_r("mean_beta");
        current_statement__ = 37;
        pos__ = 1;
        current_statement__ = 37;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 37;
          stan::model::assign(mean_beta, mean_beta_flat__[(pos__ - 1)],
            "assigning variable mean_beta", stan::model::index_uni(sym1__));
          current_statement__ = 37;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 38;
      stan::math::validate_non_negative_index("sd_beta", "K", K);
      current_statement__ = 39;
      context__.validate_dims("data initialization", "sd_beta", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      sd_beta_data__ = Eigen::Matrix<double,-1,1>::Constant(K,
                         std::numeric_limits<double>::quiet_NaN());
      new (&sd_beta)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(sd_beta_data__.data(), K);
      {
        std::vector<local_scalar_t__> sd_beta_flat__;
        current_statement__ = 39;
        sd_beta_flat__ = context__.vals_r("sd_beta");
        current_statement__ = 39;
        pos__ = 1;
        current_statement__ = 39;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 39;
          stan::model::assign(sd_beta, sd_beta_flat__[(pos__ - 1)],
            "assigning variable sd_beta", stan::model::index_uni(sym1__));
          current_statement__ = 39;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 40;
      stan::math::validate_non_negative_index("treat", "N", N);
      current_statement__ = 41;
      context__.validate_dims("data initialization", "treat", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      treat_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                       std::numeric_limits<double>::quiet_NaN());
      new (&treat)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(treat_data__.data(), N);
      {
        std::vector<local_scalar_t__> treat_flat__;
        current_statement__ = 41;
        treat_flat__ = context__.vals_r("treat");
        current_statement__ = 41;
        pos__ = 1;
        current_statement__ = 41;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 41;
          stan::model::assign(treat, treat_flat__[(pos__ - 1)],
            "assigning variable treat", stan::model::index_uni(sym1__));
          current_statement__ = 41;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 42;
      context__.validate_dims("data initialization", "tau_mean", "double",
        std::vector<size_t>{});
      tau_mean = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 42;
      tau_mean = context__.vals_r("tau_mean")[(1 - 1)];
      current_statement__ = 43;
      context__.validate_dims("data initialization", "tau_sd", "double",
        std::vector<size_t>{});
      tau_sd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 43;
      tau_sd = context__.vals_r("tau_sd")[(1 - 1)];
      current_statement__ = 43;
      stan::math::check_greater_or_equal(function__, "tau_sd", tau_sd, 0);
      current_statement__ = 44;
      context__.validate_dims("data initialization", "run_estimation", "int",
        std::vector<size_t>{});
      run_estimation = std::numeric_limits<int>::min();
      current_statement__ = 44;
      run_estimation = context__.vals_i("run_estimation")[(1 - 1)];
      current_statement__ = 44;
      stan::math::check_greater_or_equal(function__, "run_estimation",
        run_estimation, 0);
      current_statement__ = 44;
      stan::math::check_less_or_equal(function__, "run_estimation",
        run_estimation, 1);
      current_statement__ = 45;
      stan::math::validate_non_negative_index("X_std", "N", N);
      current_statement__ = 46;
      stan::math::validate_non_negative_index("X_std", "K", K);
      current_statement__ = 47;
      X_std_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, K,
                       std::numeric_limits<double>::quiet_NaN());
      new (&X_std)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_std_data__.data(), N, K);
      current_statement__ = 48;
      stan::math::validate_non_negative_index("mean_X", "K", K);
      current_statement__ = 49;
      mean_X_data__ = Eigen::Matrix<double,-1,1>::Constant(K,
                        std::numeric_limits<double>::quiet_NaN());
      new (&mean_X)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(mean_X_data__.data(), K);
      current_statement__ = 50;
      stan::math::validate_non_negative_index("sd_X", "K", K);
      current_statement__ = 51;
      sd_X_data__ = Eigen::Matrix<double,-1,1>::Constant(K,
                      std::numeric_limits<double>::quiet_NaN());
      new (&sd_X) Eigen::Map<Eigen::Matrix<double,-1,1>>(sd_X_data__.data(),
        K);
      current_statement__ = 56;
      for (int k = 1; k <= K; ++k) {
        current_statement__ = 52;
        stan::model::assign(mean_X,
          stan::math::mean(
            stan::model::rvalue(X, "X", stan::model::index_omni(),
              stan::model::index_uni(k))), "assigning variable mean_X",
          stan::model::index_uni(k));
        current_statement__ = 53;
        stan::model::assign(sd_X,
          stan::math::sd(
            stan::model::rvalue(X, "X", stan::model::index_omni(),
              stan::model::index_uni(k))), "assigning variable sd_X",
          stan::model::index_uni(k));
        current_statement__ = 54;
        stan::model::assign(X_std,
          stan::math::divide(
            stan::math::subtract(
              stan::model::rvalue(X, "X", stan::model::index_omni(),
                stan::model::index_uni(k)),
              stan::model::rvalue(mean_X, "mean_X", stan::model::index_uni(k))),
            stan::model::rvalue(sd_X, "sd_X", stan::model::index_uni(k))),
          "assigning variable X_std", stan::model::index_omni(),
          stan::model::index_uni(k));
      }
      current_statement__ = 57;
      stan::math::validate_non_negative_index("beta", "K", K);
      current_statement__ = 58;
      stan::math::validate_non_negative_index("y_sim", "N", N);
      current_statement__ = 59;
      stan::math::validate_non_negative_index("y0", "N", N);
      current_statement__ = 60;
      stan::math::validate_non_negative_index("y1", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + K + 1;
  }
  inline std::string model_name() const final {
    return "model_logit";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_logit_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ alpha = DUMMY_VAR__;
      current_statement__ = 1;
      alpha = in__.template read<local_scalar_t__>();
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 2;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 3;
      tau = in__.template read<local_scalar_t__>();
      {
        current_statement__ = 16;
        stan::math::validate_non_negative_index("theta", "N", N);
        Eigen::Matrix<local_scalar_t__,-1,1> theta =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
        current_statement__ = 18;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(alpha, mean_alpha,
                         sd_alpha));
        current_statement__ = 21;
        for (int k = 1; k <= K; ++k) {
          current_statement__ = 19;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(
                           stan::model::rvalue(beta, "beta",
                             stan::model::index_uni(k)),
                           stan::model::rvalue(mean_beta, "mean_beta",
                             stan::model::index_uni(k)),
                           stan::model::rvalue(sd_beta, "sd_beta",
                             stan::model::index_uni(k))));
        }
        current_statement__ = 22;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(tau, tau_mean,
                         tau_sd));
        current_statement__ = 23;
        stan::model::assign(theta,
          stan::math::add(
            stan::math::add(alpha, stan::math::multiply(X_std, beta)),
            stan::math::multiply(tau, treat)), "assigning variable theta");
        current_statement__ = 26;
        if (stan::math::logical_eq(run_estimation, 1)) {
          current_statement__ = 24;
          lp_accum__.add(stan::math::bernoulli_logit_lpmf<propto__>(y, theta));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_logit_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double alpha = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      alpha = in__.template read<local_scalar_t__>();
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      double tau = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      tau = in__.template read<local_scalar_t__>();
      out__.write(alpha);
      out__.write(beta);
      out__.write(tau);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> y_sim =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> y0 =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> y1 =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      double eta = std::numeric_limits<double>::quiet_NaN();
      double mean_y_sim = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 13;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 9;
        stan::model::assign(y_sim,
          stan::math::bernoulli_logit_rng(((alpha + (tau *
            stan::model::rvalue(treat, "treat", stan::model::index_uni(i))))
            +
            stan::math::dot_product(
              stan::model::rvalue(X_std, "X_std", stan::model::index_uni(i)),
              beta)), base_rng__), "assigning variable y_sim",
          stan::model::index_uni(i));
        current_statement__ = 10;
        stan::model::assign(y0,
          stan::math::bernoulli_logit_rng((alpha +
            stan::math::dot_product(
              stan::model::rvalue(X_std, "X_std", stan::model::index_uni(i)),
              beta)), base_rng__), "assigning variable y0",
          stan::model::index_uni(i));
        current_statement__ = 11;
        stan::model::assign(y1,
          stan::math::bernoulli_logit_rng(((alpha +
            stan::math::dot_product(
              stan::model::rvalue(X_std, "X_std", stan::model::index_uni(i)),
              beta)) + tau), base_rng__), "assigning variable y1",
          stan::model::index_uni(i));
      }
      current_statement__ = 14;
      eta = (stan::math::mean(y1) - stan::math::mean(y0));
      current_statement__ = 15;
      mean_y_sim = stan::math::mean(y_sim);
      out__.write(y_sim);
      out__.write(y0);
      out__.write(y1);
      out__.write(eta);
      out__.write(mean_y_sim);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ alpha = DUMMY_VAR__;
      current_statement__ = 1;
      alpha = in__.read<local_scalar_t__>();
      out__.write(alpha);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K),
        "assigning variable beta");
      out__.write(beta);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 3;
      tau = in__.read<local_scalar_t__>();
      out__.write(tau);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "alpha", "double",
        std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "tau", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ alpha = DUMMY_VAR__;
      current_statement__ = 1;
      alpha = context__.vals_r("alpha")[(1 - 1)];
      out__.write(alpha);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 2;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          stan::model::assign(beta, beta_flat__[(pos__ - 1)],
            "assigning variable beta", stan::model::index_uni(sym1__));
          current_statement__ = 2;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 3;
      tau = context__.vals_r("tau")[(1 - 1)];
      out__.write(tau);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"alpha", "beta", "tau"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"y_sim", "y0", "y1", "eta", "mean_y_sim"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(K)},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{}, std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "alpha");
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "tau");
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_sim" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "y0" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "y1" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "eta");
      param_names__.emplace_back(std::string() + "mean_y_sim");
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "alpha");
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "tau");
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_sim" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "y0" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "y1" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "eta");
      param_names__.emplace_back(std::string() + "mean_y_sim");
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"y_sim\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"y0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"y1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"eta\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"mean_y_sim\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"y_sim\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"y0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"y1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"eta\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"mean_y_sim\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((1 + K) + 1);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (((((N + N)
      + N) + 1) + 1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((1 + K) + 1);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (((((N + N)
      + N) + 1) + 1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_logit_namespace::model_logit;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_logit_namespace::profiles__;
}
#endif
#endif
