#ifndef QUADMOD_HPP
#define QUADMOD_HPP

#include <RcppArmadillo.h>

namespace quadmod {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        colvec df = wt - adjwt;
        return 0.5 * sum(df % df / wt);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        colvec df = adjwt - wt;
        return df / wt;
    }

}

#endif // QUADMOD_HPP
