% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_from_hash_table.R
\name{update_from_hash_table}
\alias{update_from_hash_table}
\title{Update File Names Based on New Parameters in Adjusted Hash Table}
\usage{
update_from_hash_table(
  hash_table,
  rds_folder,
  hash_includes_timestamp = FALSE,
  ignore_na = TRUE,
  alphabetical_order = TRUE,
  algo = "xxhash64"
)
}
\arguments{
\item{hash_table}{A file path to a modified hash table generated by \code{create_hash_table}.}

\item{rds_folder}{A string specifying the directory containing the RDS files associated with the hash table.}

\item{hash_includes_timestamp}{Logical; if TRUE, timestamps are included in the hash generation.}

\item{ignore_na}{Logical; if TRUE, NA values are ignored during hash generation.}

\item{alphabetical_order}{Logical; if TRUE, parameters are sorted alphabetically before hash generation.}

\item{algo}{Character string specifying the hashing algorithm to use. Default is \code{"xxhash64"}. See \code{?digest}}
}
\value{
The function does not return a value but saves updated RDS files and deletes old files as needed.
}
\description{
This function updates names of existing results by re-hashing each set of
parameters with potentially updated values based on adjustments made to a
hash table (see \code{?create_hash_table}) by user. It loads RDS files based
on their existing hashes, compares to the corresponding entry in a hash table,
generates new hashes where needed, and saves the files with the new hashes.
The old files are deleted if their hashes differ from the new ones.
}
\examples{
## Setup
tmp_dir <- file.path(tempdir(), "example")
dir.create(tmp_dir)

## Save objects
obj1 <- rnorm(1000)
obj2 <- data.frame(
  x = runif(100),
  y = "something",
  z = rep(c(TRUE, FALSE), 50)
)
obj3 <- list(obj1, obj2)

params1 <- list(
  distribution = "normal",
  other_params = list(param1 = TRUE, param2 = 1, param3 = NA)
)
params2 <- list(
  distribution = "uniform",
  other_params = list(param1 = FALSE, param2 = 2, param3 = "1", param4 = 4)
)
params3 <- list(
  distribution = "composite",
  other_params = list(param1 = TRUE, param2 = 3, param3 = 1)
)

save_objects(tmp_dir, obj1, params1)
save_objects(tmp_dir, obj2, params2)
save_objects(tmp_dir, obj3, params3)

## Create hash table
create_hash_table(tmp_dir, save_path = file.path(tmp_dir, "hash_table.csv"))

## Read in hash table, make a change, and save
hash_table <- read.csv(file.path(tmp_dir, "hash_table.csv"))
hash_table$distribution <- "something different"
write.csv(hash_table, file.path(tmp_dir, "hash_table.csv"))

## See file names before change
list.files(tmp_dir)

update_from_hash_table(
  hash_table = file.path(tmp_dir, "hash_table.csv"),
  rds_folder = tmp_dir
)

## See difference to before running update_hash_table()
list.files(tmp_dir)

## Cleanup
unlink(tmp_dir, recursive = TRUE)
}
\seealso{
\code{\link[=create_hash_table]{create_hash_table()}}
}
