% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{inline_select}
\alias{inline_select}
\title{Inline select list input}
\usage{
inline_select(id, choices, selected = NULL, multiple = FALSE, meaning = NULL)
}
\arguments{
\item{id}{The \code{input} slot that will be used to access the value.}

\item{choices}{Vector or list of values to select from. Provide one of the
following:
\itemize{
\item Use an unnamed character vector, such as \code{c("dog", "cat", "bee")}, for the
most basic case, where you have a list of strings you want the user to
select from.
\item Use a named character vector, such as \code{c("Dog" = "dog", "Nice Kitty" = "cat", "Bee" = "bee")} if you want the options
displayed to the user (the names; here, Dog, Nice Kitty, and Bee) to
differ from the values passed to Shiny (the values; here, \code{"dog"},
\code{"cat"}, and \code{"bee"}).
\item Use a named list, where each element is a "sub-list", to group the items
under headings; the names at the top level of the list will be the
heading titles and the "sub-lists" are the items appearing under that
heading. For example, if you pass
\code{list(Mammals = c("Dog" = "dog", "Nice Kitty" = "cat"), Invertebrates = c("Bee" = "bee"))} then Dog and Nice Kitty will appear
under the Mammals heading, while Bee will appear under the Invertebrates
heading, and the value passed to the Shiny server will be either
\code{"dog"}, \code{"cat"}, or \code{"bee"}.
}}

\item{selected}{The initially selected option's value. If \code{NULL}, use the
first item in \code{choices}.}

\item{multiple}{Whether to allow multiple selections. As of inshiny version
0.1.0, the version of \link{inline_select} with \code{multiple = TRUE} looks and
behaves a bit differently from the version of \link{inline_select} with
\code{multiple = FALSE}. The package authors are working on eliminating this
inconsistency.}

\item{meaning}{A descriptive label, for people using assistive technology
such as screen readers.}
}
\value{
An inline widget to be included in an \code{\link[=inline]{inline()}} wrapper.
}
\description{
A select list input similar to \code{\link[shiny:selectInput]{shiny::selectInput()}} that can be
included in an \code{\link[=inline]{inline()}} wrapper.
}
\examples{
ui <- bslib::page_fixed(
    shiny::h1("Pet registration form"),
    inline("My ",
        inline_select("species", c("dog", "cat"), meaning = "Pet species"),
        "'s name is ",
        inline_select("name", list("Dog names" = c("Fido", "Rex"),
            "Cat names" = c("Felix", "Boots")), selected = "Rex"),
        ".")
)
}
\seealso{
\link[shiny:selectInput]{shiny::selectInput} for how the select input works with your Shiny server.
}
