% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/product_mix_storelevel.R
\name{productmix_storelevel}
\alias{productmix_storelevel}
\title{productmix_storelevel}
\usage{
productmix_storelevel(
  SKUs,
  sales,
  revenue,
  storeofsku,
  na.rm = TRUE,
  plot = FALSE
)
}
\arguments{
\item{SKUs, }{charachter, a vector of SKU names.}

\item{sales, }{vector, a vector of items sold per sku, should be the same number of rows as SKUs.}

\item{revenue, }{vector, a vector of total revenue  per sku, should be the same number of rows as SKUs.}

\item{storeofsku, }{vector, which store the SKU is sold at.should be the same number of rows as SKUs.}

\item{na.rm, }{logical and by default is TRUE}

\item{plot, }{default is FALSE,if true a plot is generated}
}
\value{
a dataframe that contains ABC categories by store with a bar plot of the count of items in each category.
}
\description{
Identyfing ABC category based on the pareto rule for both demand and selling price,a mix of nine categories are produced.
Identyfing ABC category based on the pareto rule.A category is up to 80%. B category is up 95% and C category is up to 100%.
in this fuction the data is splitted by store and a product mix is made on each store individually.
}
\note{
this is the first version of the inventorize package, all the functions are common knowledge for supply chain without
any academic contribution from my side, the aim is to facilitate and ease much of the bookkeeping that is endured during stock analysis.
}
\examples{
productmix_storelevel(c(1:1000),sales = runif(1000,4,10000),
revenue  = rnorm(1000,100,20),storeofsku = rep(seq(1:10),100))
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
