% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invexp.R
\name{invexp}
\alias{invexp}
\alias{dinvexp}
\alias{pinvexp}
\alias{qinvexp}
\alias{rinvexp}
\title{The Inverse Exponential Distribution}
\usage{
dinvexp(x, rate = 1, log = FALSE)

pinvexp(q, rate = 1, lower.tail = TRUE, log.p = FALSE)

qinvexp(p, rate = 1, lower.tail = TRUE, log.p = FALSE)

rinvexp(n, rate = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{rate}{degrees of freedom (non-negative, but can be non-integer).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X
\leq x]}; if \code{FALSE} \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be
the number required.}
}
\description{
Density, distribution function, quantile function and random generation for
the inverse exponential distribution.
}
\details{
The functions \verb{(d/p/q/r)invexp()} simply wrap those of the standard
\verb{(d/p/q/r)exp()} R implementation, so look at, say, \code{\link[stats:Exponential]{stats::dexp()}} for
details.
}
\examples{

s <- seq(0, 10, .01)
plot(s, dinvexp(s, 2), type = 'l')

f <- function(x) dinvexp(x, 2)
q <- 3
integrate(f, 0, q)
(p <- pinvexp(q, 2))
qinvexp(p, 2) # = q
mean(rinvexp(1e5, 2) <= q)

pinvgamma(q, 1, 2)



}
\seealso{
\code{\link[stats:Exponential]{stats::dexp()}}; these functions just wrap the \verb{(d/p/q/r)exp()}
functions.
}
