% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward_linkages.R
\name{forward_linkages}
\alias{forward_linkages}
\title{Forward linkages}
\usage{
forward_linkages(output_coefficient_matrix, digits = NULL)
}
\arguments{
\item{output_coefficient_matrix}{An output coefficient matrix created with
\code{\link[=output_coefficient_matrix_create]{output_coefficient_matrix_create()}}.}

\item{digits}{Integer. Number of decimals for rounding. Defaults to \code{NULL}
(no rounding).}
}
\value{
A \code{data.frame} with two columns:
\itemize{
\item The metadata column from the input matrix (sector/product names)
\item \code{forward_linkages}: the forward linkage indicator values
}
}
\description{
Forward linkages capture how the increased output of a sector
provides additional inputs to other sectors, enabling them to expand
production.
}
\details{
Defined as the row sums of the Ghosh inverse, in line with the
Eurostat Manual of Supply, Use and Input-Output Tables (pp. 506–507) and
the United Nations \emph{Handbook on Supply and Use Tables and Input-Output
Tables with Extensions and Applications} (p. 637).
}
\examples{
data_table <- iotable_get()

de_out <- output_coefficient_matrix_create(
  data_table, "tfu",
  digits = 4
)

forward_linkages(
  output_coefficient_matrix = de_out,
  digits = 4
)
}
\seealso{
Other linkage functions: 
\code{\link{backward_linkages}()}
}
\concept{linkage functions}
