% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_process_extract.R
\name{download_extract}
\alias{download_extract}
\title{Download a completed IPUMS data extract}
\usage{
download_extract(
  extract,
  download_dir = getwd(),
  overwrite = FALSE,
  progress = TRUE,
  api_key = Sys.getenv("IPUMS_API_KEY")
)
}
\arguments{
\item{extract}{One of:
\itemize{
\item An \code{\link[=ipums_extract-class]{ipums_extract}} object
\item The data collection and extract number formatted as a string of the
form \code{"collection:number"} or as a vector of the form
\code{c("collection", number)}
\item An extract number to be associated with your default IPUMS
collection. See \code{\link[=set_ipums_default_collection]{set_ipums_default_collection()}}
}

For a list of codes used to refer to each collection, see
\code{\link[=ipums_data_collections]{ipums_data_collections()}}.}

\item{download_dir}{Path to the directory where the files should be written.
Defaults to current working directory.}

\item{overwrite}{If \code{TRUE}, overwrite files with the same name that
already exist in \code{download_dir}. Defaults to \code{FALSE}.}

\item{progress}{If \code{TRUE}, output progress bar showing the status of the
download request. Defaults to \code{TRUE}.}

\item{api_key}{API key associated with your user account. Defaults to the
value of the \code{IPUMS_API_KEY} environment variable. See
\code{\link[=set_ipums_api_key]{set_ipums_api_key()}}.}
}
\value{
The path(s) to the files required to read the data
requested in the extract, invisibly.

For NHGIS, paths will be named with either \code{"data"} (for tabular data
files) or \code{"shape"} (for spatial data files) to
indicate the type of data the file contains.
}
\description{
Download IPUMS data extract files via the IPUMS API and save them on your
computer.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\details{
For NHGIS extracts, data files and GIS files (shapefiles) will be saved in
separate .zip archives. \code{download_extract()} will return a character vector
including the file paths to all downloaded files.

For microdata extracts, only the file path to the downloaded .xml DDI file
will be returned, as it is sufficient for reading the data provided in the
associated .dat.gz data file.
}
\examples{
usa_extract <- define_extract_micro(
  collection = "usa",
  description = "2013-2014 ACS Data",
  samples = c("us2013a", "us2014a"),
  variables = c("SEX", "AGE", "YEAR")
)

\dontrun{
submitted_extract <- submit_extract(usa_extract)

downloadable_extract <- wait_for_extract(submitted_extract)

# For microdata, the path to the DDI .xml codebook file is provided.
usa_xml_file <- download_extract(downloadable_extract)

# Load with a `read_ipums_micro_*()` function
usa_data <- read_ipums_micro(usa_xml_file)

# You can also download previous extracts with their collection and number:
nhgis_files <- download_extract("nhgis:1")

# NHGIS extracts return a path to both the tabular and spatial data files,
# as applicable.
nhgis_data <- read_ipums_agg(data = nhgis_files["data"])

# Load NHGIS spatial data
nhgis_geog <- read_ipums_sf(data = nhgis_files["shape"])
}
}
\seealso{
\code{\link[=read_ipums_micro]{read_ipums_micro()}} or \code{\link[=read_ipums_agg]{read_ipums_agg()}} to read tabular
data from an IPUMS extract.

\code{\link[=read_ipums_sf]{read_ipums_sf()}} to read spatial data from an IPUMS extract.

\code{\link[=ipums_list_files]{ipums_list_files()}} to list files in an IPUMS extract.
}
