% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_weight.R
\name{gen.weight}
\alias{gen.weight}
\title{Generate Weights}
\usage{
gen.weight(n = 41, dist = "norm", mu = 0, sigma = 1, l = -4, u = 4, theta)
}
\arguments{
\item{n}{An integer specifying the number of theta (node) values for which
weights are to be generated. Default is 41.}

\item{dist}{A character string indicating the distribution type used to
generate weights. Available options are \code{"norm"} for a normal distribution,
\code{"unif"} for a uniform distribution, and \code{"emp"} for an empirical
distribution.
\itemize{
\item If \code{dist = "norm"}, either \code{n} or \code{theta} must be provided.
\item If \code{dist = "unif"}, only \code{n} is applicable.
\item If \code{dist = "emp"}, only \code{theta} must be specified.
}}

\item{mu, sigma}{Mean and standard deviation of the normal distribution (used
when \code{dist = "norm"}).}

\item{l, u}{Lower and upper bounds of the uniform distribution (used when
\code{dist = "unif"}).}

\item{theta}{A numeric vector of empirical theta (node) values for which
weights are generated.}
}
\value{
A data frame with two columns:
\itemize{
\item \code{theta}: The theta (node) values.
\item \code{weight}: The corresponding normalized weights.
}
}
\description{
This function generates a set of normalized weights based on theta (ability)
values to be used in functions such as \code{\link[=est_score]{est_score()}},
\code{\link[=sx2_fit]{sx2_fit()}}, and \code{\link[=covirt]{covirt()}}.
}
\details{
If \code{theta} is not specified, \emph{n} equally spaced quadrature points
and corresponding weights are generated from either the normal or uniform
distribution:
\itemize{
\item When \code{dist = "norm"}, Gaussian quadrature points and weights are computed
using \code{gauss.quad.prob()} from the \pkg{statmod} package.
\item When \code{dist = "unif"}, equally spaced points are drawn from the specified
interval [\code{l}, \code{u}], and weights are proportional to the uniform density.
}

If \code{theta} is specified:
\itemize{
\item When \code{dist = "norm"}, the weights are proportional to the normal density
evaluated at each theta value and normalized to sum to 1.
\item When \code{dist = "emp"}, equal weights are assigned to each provided theta value.
}
}
\examples{
## Example 1:
## Generate 41 Gaussian quadrature points and weights from the normal distribution
gen.weight(n = 41, dist = "norm", mu = 0, sigma = 1)

## Example 2:
## Generate 41 theta values and weights from the uniform distribution,
## given a minimum value of -4 and a maximum value of 4
gen.weight(n = 41, dist = "unif", l = -4, u = 4)

## Example 3:
## Generate normalized weights from the standard normal distribution,
## given a user-defined set of theta values
theta <- seq(-4, 4, by = 0.1)
gen.weight(dist = "norm", mu = 0, sigma = 1, theta = theta)

## Example 4:
## Generate equal normalized weights for theta values
## randomly sampled from the standard normal distribution
theta <- rnorm(100)
gen.weight(dist = "emp", theta = theta)

}
\seealso{
\code{\link[=est_score]{est_score()}}, \code{\link[=sx2_fit]{sx2_fit()}}, \code{\link[=covirt]{covirt()}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
